/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Filip Gospodinov
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "scrolling_screen.h"

#include "util/loading/factory.h"
#include "util/loading/load_param.h"

#include "debug.h"
#include "material.h"
#include "state.h"
// #include "camera.h"

ObjectListDefinition(ScrollingScreen);
CREATE_FACTORY(ScrollingScreen);



/**
 *
 */
ScrollingScreen::ScrollingScreen()
{
  this->init();
}


/**
 *
 */
ScrollingScreen::ScrollingScreen(const TiXmlElement* root)
{
  this->init();

  if( root != NULL)
    this->loadParams(root);
}


/**
 *
 */
ScrollingScreen::~ScrollingScreen()
{}


/**
 *
 */
void ScrollingScreen::init()
{
  this->registerObject(this, ScrollingScreen::_objectList);
  this->toList(OM_COMMON);

  this->material = new Material();
  this->material->setDiffuse(0,0,0);
  this->material->setBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

  this->isTransparent = false;
  this->transparency = 1.0;
}


/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void ScrollingScreen::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);

  LoadParam(root, "setSpeed", this, ScrollingScreen, setSpeed);

  LoadParam(root, "setHeight", this, ScrollingScreen, setViewHeight);

  LoadParam(root, "setSize", this, ScrollingScreen, setSize);
}




void ScrollingScreen::draw() const
{
  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_LIGHTING);
  glEnable(GL_BLEND);   // Turn Blending On

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  /* translate */
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);
  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

  this->material->select();

  glBegin(GL_QUADS);

  glTexCoord2f(0., 0.);
  glVertex3f(0., -this->xSize, -this->ySize);

//   glTexCoord2f();
  glVertex3f(0., -this->xSize, -this->ySize);

//   glTexCoord2f();
  glVertex3f(0., -this->xSize, -this->ySize);

//   glTexCoord2f();
  glVertex3f(0., -this->xSize, -this->ySize);

  glEnd();

  glPopMatrix();
  glPopAttrib();
}

/**
 *
 */
void ScrollingScreen::tick (float time)
{

}

void ScrollingScreen::fadeIn(float speed)
{

}

void ScrollingScreen::fadeOut(float speed)
{

}
