/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "hud.h"

#include "state.h"
#include "debug.h"

#include "world_entities/weapons/weapon_manager.h"
#include "glgui_widget.h"
#include "glgui_box.h"
#include "glgui_bar.h"
#include "elements/glgui_energywidgetvertical.h"

#include "glgui_inputline.h"
#include "specials/glgui_notifier.h"
#include "elements/glgui_radar.h"
#include "world_entities/space_ships/space_ship.h"



/// HACK
#include "player.h"
#include "playable.h"

ObjectListDefinition(Hud);
/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
Hud::Hud ()
{
  this->registerObject(this, Hud::_objectList);

  //this->setSize2D(
  this->weaponManager = NULL;
  this->weaponManagerSecondary = NULL;
  this->energyWidget = NULL;
  this->shieldWidget = NULL;
  this->armorWidget = NULL;
  //this->leftRect = NULL;
  //this->rightRect = NULL;
  this->resX = 1;
  this->resY = 1;

  this->overlayPercentage = 40;
  this->overlayActive = false;
  this->rightRect = new OrxGui::GLGuiImage();
  this->leftRect = new OrxGui::GLGuiImage();

  this->inputLine = new OrxGui::GLGuiInputLine();
  this->inputLine->setParent2D(this);
  this->notifier = new OrxGui::GLGuiNotifier();
  this->notifier->setParent2D(this);
  notifier->setAbsCoor2D(100,100);

  this->_radar = new OrxGui::GLGuiRadar();
  this->radarCenterNode = NULL;

  this->subscribeEvent(ES_ALL, EV_VIDEO_RESIZE);
  this->subscribeEvent(ES_ALL, SDLK_TAB);

  //this->shipValuesBox = NULL;
}


/**
 * standard deconstructor
*/
Hud::~Hud ()
{
  delete this->inputLine;
  delete this->notifier;

  delete this->_radar;
  delete this->rightRect;
  delete this->leftRect;
  //if (this->shipValuesBox != NULL)
    //delete this->shipValuesBox;

  // delete what has to be deleted here
}


void Hud::loadParams(const TiXmlElement* root)
{
  Element2D::loadParams(root);
}

void Hud::notifyUser(const std::string& message)
{
  this->notifier->pushNotifyMessage(message);
}

void Hud::setBackGround()
{}

void Hud::setEnergyWidget(OrxGui::GLGuiWidget* widget)
{
  //if (this->shipValuesBox == NULL)
    //this->createShipValuesBox();

  // decopple old widget
  if (this->energyWidget != NULL)
  {
    this->energyWidget->hide();
  }

  this->energyWidget = widget;
  if (this->energyWidget != NULL)
  {
    //this->energyWidget->shiftDir2D(270);
    //dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (this->energyWidget)->setDisplayedName("Electronics");
    //this->shipValuesBox->pack(this->energyWidget);
    //dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (this->energyWidget)->setStandardSettings();
    this->energyWidget->setParent2D(this->leftRect);
    dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (this->energyWidget)->setDisplayedImage("textures/gui/gui_electronics_icon.png");
    this->energyWidget->show();
    /*    this->energyWidget->frontMaterial().setDiffuseMap("hud_energy_bar.png");
        this->energyWidget->frontMaterial().setBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);*/
  }

  this->updateResolution();
}

void Hud::setShiledWidget(OrxGui::GLGuiWidget* widget)
{
  /*
  if (this->shipValuesBox == NULL)
    this->createShipValuesBox();
  */

  // decopple old widget
  if (this->shieldWidget != NULL)
  {
    this->shieldWidget->hide();
  }

  this->shieldWidget = widget;
  if (this->shieldWidget != NULL)
  {
    //this->shieldWidget->shiftDir2D(270);
    //this->shipValuesBox->pack(this->shieldWidget);
    //dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (this->shieldWidget)->setStandardSettings();
    this->shieldWidget->setParent2D(this->leftRect);
    dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (this->shieldWidget)->setDisplayedImage("textures/gui/gui_shield_icon.png");
    this->shieldWidget->show();
    /*    this->shieldWidget->frontMaterial().setDiffuseMap("hud_energy_bar.png");
        this->shieldWidget->frontMaterial().setBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);*/
  }
  else
    printf("schild im hud nicht uebergeben!!!!!!!!!!!!!!!!!!!!!!!!!");

  this->updateResolution();
}

void Hud::setArmorWidget(OrxGui::GLGuiWidget* widget)
{
  /*
  if (this->shipValuesBox == NULL)
    this->createShipValuesBox();
  */

// decopple old widget
  if (this->armorWidget != NULL)
  {
    this->armorWidget->hide();
  }

  this->armorWidget = widget;
  if (this->armorWidget != NULL)
  {
    //this->armorWidget->shiftDir2D(270);
    //this->shipValuesBox->pack(this->armorWidget);
    //dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (this->armorWidget)->setStandardSettings();
    this->armorWidget->setParent2D(this->leftRect);
    dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (this->armorWidget)->setDisplayedImage("textures/gui/gui_health_icon.png");
    this->armorWidget->show();
    /*    this->armorWidget->frontMaterial().setDiffuseMap("hud_energy_bar.png");
        this->armorWidget->frontMaterial().setBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);*/
  }

  this->updateResolution();
}

void Hud::setWeaponManager(WeaponManager* weaponMan, WeaponManager* weaponManSec)
{
  //clearWeaponManager();

  //Hide all widgets
  if (this->weaponManager != NULL)
  {
    for (unsigned int i = 0; i < this->weaponManager->getSlotCount(); i++)
    {
      Weapon* weapon = this->weaponManager->getWeapon(i);
      if (weapon != NULL)
      {
        weapon->getEnergyWidget()->hide();
        //this->weaponsWidgetsPrim.remove(dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (weapon->getEnergyWidget()));
      }
    }
  }

  if (this->weaponManagerSecondary != NULL)
  {
    for (unsigned int i = 0; i < this->weaponManagerSecondary->getSlotCount(); i++)
    {
      Weapon* weapon = this->weaponManagerSecondary->getWeapon(i);
      if (weapon != NULL)
      {
        weapon->getEnergyWidget()->hide();
        //this->weaponsWidgetsSec.remove(dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (weapon->getEnergyWidget()));
      }
    }
  }

  this->weaponManager = weaponMan;
  this->weaponManagerSecondary = weaponManSec; 

  this->updateWeaponManager();
  //  this->updateResolution();
}

/*
void Hud::clearWeaponManager()
{
  //Hide all widgets
  if (this->weaponManager != NULL)
  {
    for (unsigned int i = 0; i < this->weaponManager->getSlotCount(); i++)
    {
      Weapon* weapon = this->weaponManager->getWeapon(i);
      if (weapon != NULL)
      {
        weapon->getEnergyWidget()->hide();
        //this->weaponsWidgetsPrim.remove(dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (weapon->getEnergyWidget()));
      }
    }
  }

  if (this->weaponManagerSecondary != NULL)
  {
    for (unsigned int i = 0; i < this->weaponManagerSecondary->getSlotCount(); i++)
    {
      Weapon* weapon = this->weaponManagerSecondary->getWeapon(i);
      if (weapon != NULL)
      {
        weapon->getEnergyWidget()->hide();
        //this->weaponsWidgetsSec.remove(dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (weapon->getEnergyWidget()));
      }
    }
  }

  //this->weaponsWidgetsPrim.clear();
  //this->weaponsWidgetsSec.clear();
}
*/

void Hud::updateWeaponManager()
{
  // hide all the Widgets
  
  std::list<OrxGui::GLGuiEnergyWidgetVertical*>::iterator weaponWidget;
  for (weaponWidget = this->weaponsWidgetsPrim.begin(); weaponWidget != this->weaponsWidgetsPrim.end(); weaponWidget++)
  {
    (*weaponWidget)->hide();
  }
  this->weaponsWidgetsPrim.clear();

  for (weaponWidget = this->weaponsWidgetsSec.begin(); weaponWidget != this->weaponsWidgetsSec.end(); weaponWidget++)
  {
    (*weaponWidget)->hide();
  }
  this->weaponsWidgetsSec.clear();
  

  // add all that we need again.

  if (this->weaponManager != NULL)
    for (unsigned int i = 0; i < this->weaponManager->getSlotCount(); i++)
    {
      Weapon* weapon = this->weaponManager->getWeapon(i);
      if (weapon != NULL)
      {
        //PRINTF(0)("WEAPON %s::%s in Slots\n", weapon->getClassCName(), weapon->getName());
        weapon->getEnergyWidget()->setParent2D(this->rightRect);
        weapon->getEnergyWidget()->show();
        weapon->getEnergyWidget()->setBackgroundColor(Color(.8,.2,.11, 0.1));
        weapon->getEnergyWidget()->setFrontColor(Color( .2,.5,.7,.6));
        weapon->getEnergyWidget()->setWidgetSize(120,30);
        //weapon->getEnergyWidget()->frontMaterial().setTransparency(.6);
        this->weaponsWidgetsPrim.push_back(dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (weapon->getEnergyWidget()));
      }
    }

  if (this->weaponManagerSecondary != NULL)
    for (unsigned int i = 0; i < this->weaponManagerSecondary->getSlotCount(); i++)
    {
      Weapon* weapon = this->weaponManagerSecondary->getWeapon(i);
      if (weapon != NULL)
      {
        //PRINTF(0)("WEAPON %s::%s in Slots\n", weapon->getClassCName(), weapon->getName());
        weapon->getEnergyWidget()->setParent2D(this->rightRect);
        weapon->getEnergyWidget()->show();
        weapon->getEnergyWidget()->setBackgroundColor(Color(.8,.2,.11, 0.1));
        weapon->getEnergyWidget()->setFrontColor(Color( .2,.5,.7,.6));
        weapon->getEnergyWidget()->setWidgetSize(150,50);
        //weapon->getEnergyWidget()->frontMaterial().setTransparency(.6);
        this->weaponsWidgetsSec.push_back(dynamic_cast<OrxGui::GLGuiEnergyWidgetVertical*> (weapon->getEnergyWidget()));
      }
    }

  this->updateResolution();

}

void Hud::addWeaponWidget(OrxGui::GLGuiWidget* widget)
{}

void Hud::removeWeaponWidget(OrxGui::GLGuiWidget* widget)
{}

void Hud::updateResolution()
{
  this->resX = State::getResX();
  this->resY = State::getResY();

  this->setSize2D(.2 * this->resX, this->resY);
  this->notifier->setAbsCoor2D(0.7 * this->resX, 0.3 * this->resY);
  this->notifier->setWidgetSize(0.25 * this->resX, 0.6 * this->resY);

  int overlayWidth = 0;
  if (overlayPercentage >= 20)
    overlayWidth = this->resX * (overlayPercentage)/(200);
  else
    overlayWidth = this->resX * 0.1;
  //if (overlayWidth < 100)
    //overlayWidth = 100;

  this->rightRect->hide();
  this->leftRect->hide();

  this->leftRect->setParent2D(this);
  this->leftRect->setWidgetSize(float(overlayWidth), float(this->resY));
  this->leftRect->setAbsCoor2D(0,0);
  this->leftRect->setBackgroundTexture(Texture());
  this->leftRect->setBackgroundColor(Color(0,0,0.7,0.2));
  this->leftRect->setForegroundTexture(Texture());
  this->leftRect->setForegroundColor(Color(0,0,0,0));

  this->rightRect->setParent2D(this);
  this->rightRect->setWidgetSize(float(overlayWidth), float(this->resY));
  this->rightRect->setAbsCoor2D(this->resX - overlayWidth,0);
  this->rightRect->setBackgroundTexture(Texture());
  this->rightRect->setBackgroundColor(Color(0,0,0.7,0.2));
  this->rightRect->setForegroundTexture(Texture());
  this->rightRect->setForegroundColor(Color(0,0,0,0));


  if (this->overlayActive == true)
  {
    this->rightRect->show();
    this->leftRect->show();
  }


  if (State::getPlayer() && State::getPlayer()->getPlayable() && State::getObjectManager())
  {
    PRINTF(4)("UPDATING RADAR\n");
    this->_radar->setParent2D(this->leftRect);
    if (radarCenterNode == NULL)
      this->_radar->setCenterNode(State::getPlayer()->getPlayable());
    else
      this->_radar->setCenterNode(this->radarCenterNode);

    //this->_radar->addEntityList(&State::getObjectManager()->getEntityList((OM_LIST)(State::getPlayer()->getPlayable()->getOMListNumber()+1)), Color(.4, .4, 1.0));
    this->_radar->addEntityList(&State::getObjectManager()->getEntityList(OM_GROUP_00), Color(1, 0, 0));
    this->_radar->addEntityList(&State::getObjectManager()->getEntityList(OM_GROUP_01), Color(0, 0, 1));
    this->_radar->setAbsCoor2D(0, 0.01 * this->resY);
    this->_radar->setWidgetSize(overlayWidth, overlayWidth);
    this->_radar->setRange(300);
    this->_radar->show();
    
    int statWidgetsNumber = 0;
    float expectedArmorSizeX = 0;
    float expectedArmorSizeY = 0;
    float newSizeY = 0; float newSizeX = 0;
    float moduloWidth = 0;

    if (this->armorWidget != NULL)
    {
      expectedArmorSizeX = 150;
      expectedArmorSizeY = 50;
      statWidgetsNumber++;
    }

    if (this->shieldWidget != NULL)
      statWidgetsNumber++;
    
    if (this->energyWidget != NULL)
      statWidgetsNumber++;

    if (expectedArmorSizeY * statWidgetsNumber > overlayWidth)
    {
      newSizeY = overlayWidth / float(statWidgetsNumber);
      newSizeX = expectedArmorSizeX;
      PRINTF(0)("Statwidgets resized\n");
    }
    else
    {
      newSizeY = expectedArmorSizeY;
      newSizeX = expectedArmorSizeX;
      moduloWidth = int(overlayWidth) % int(expectedArmorSizeY * statWidgetsNumber);
    }

    float posY = overlayWidth + newSizeX;

    if (this->armorWidget != NULL)
    {
      this->armorWidget->setSize2D(newSizeX, newSizeY);
      this->armorWidget->setRelCoor2D((statWidgetsNumber - 1) * newSizeY + 3 * moduloWidth / (statWidgetsNumber + 1),posY);
    }
    if (this->shieldWidget != NULL)
    {
      this->shieldWidget->setSize2D(newSizeX, newSizeY);
      this->shieldWidget->setRelCoor2D((statWidgetsNumber - 2) * newSizeY + 2 *moduloWidth / (statWidgetsNumber + 1),posY);
    }
    if (this->energyWidget != NULL)
    {
      this->energyWidget->setSize2D(newSizeX, newSizeY);
      this->energyWidget->setRelCoor2D(moduloWidth / (statWidgetsNumber + 1),posY);
    }

    /*
    if (this->armorWidget != NULL)
      this->armorWidget->setRelCoor2D(100,0.2*this->resY + this->armorWidget->getSizeX2D());
    if (this->shieldWidget != NULL)
      this->shieldWidget->setRelCoor2D(60,0.2*this->resY + this->armorWidget->getSizeX2D());
    if (this->energyWidget != NULL)
      this->energyWidget->setRelCoor2D(20,0.2*this->resY + this->armorWidget->getSizeX2D());
    */
    //this->shieldWidget->setRelCoor2D(0.1*this->resX + this->armorWidget->getSizeX2D(),0);
    //this->energyWidget->setRelCoor2D(0.1*this->resX + this->armorWidget->getSizeX2D() + this->shieldWidget->getSizeX2D(),0);
  }

  /*
  if (this->shipValuesBox != NULL)
  {
    this->shipValuesBox->setAbsCoor2D(0.2 * this->resX, 0.4 * this->resY);
    this->shipValuesBox->setWidgetSize(.4 * this->resX, 0.1 * this->resY);
  }
  else
    createShipValuesBox();
  */

  std::list<OrxGui::GLGuiEnergyWidgetVertical*>::iterator weaponWidget;
  Vector2D pos = Vector2D(overlayWidth, 0.4*this->resY);
  float largestWidgetSizeX = 0;
  //PRINTF(0)("Cur Pos: %f,%f\n",pos.x,pos.y);
  // out of reasons i can't get behind, this version is segfaulting when calling getSizeX2D or getSizeY2D. the other
  // element2D- related function works tough.. :s

  for (weaponWidget = this->weaponsWidgetsPrim.begin(); weaponWidget != this->weaponsWidgetsPrim.end(); weaponWidget++)
  {
    float ySize = (*weaponWidget)->getSizeY2D();
    float xSize = (*weaponWidget)->getSizeX2D();
    if (xSize > largestWidgetSizeX)
      largestWidgetSizeX = xSize;
    if (pos.x < ySize)
    {
      pos.x = overlayWidth;
      pos.y += largestWidgetSizeX;
    }
    pos.x -= ySize;
    (*weaponWidget)->setAbsCoor2D(pos.x + this->rightRect->getAbsCoor2D().x, pos.y);
    //(*weaponWidget)->setAbsCoor2D(0,100);
    (*weaponWidget)->show();
    //printf("update thing %s::%s\n", (*weaponWidget)->getClassCName(), (*weaponWidget)->getName());
  }
  
  weaponWidget = this->weaponsWidgetsSec.begin();
  float expectedWidgetSizeY = 0;
  if (weaponWidget != this->weaponsWidgetsSec.end())
  {
    expectedWidgetSizeY = (*weaponWidget)->getSizeY2D();
  }
  pos.y = resY - expectedWidgetSizeY * 0.6;
  pos.x = overlayWidth + this->rightRect->getAbsCoor2D().x;

  for (weaponWidget = this->weaponsWidgetsSec.begin(); weaponWidget != this->weaponsWidgetsSec.end(); weaponWidget++)
  {
    float ySize = (*weaponWidget)->getSizeY2D();
    float xSize = (*weaponWidget)->getSizeX2D();
    if (xSize > largestWidgetSizeX)
      largestWidgetSizeX = xSize;
    if (pos.x < ySize)
    {
      pos.x = overlayWidth;
      pos.y -= largestWidgetSizeX + expectedWidgetSizeY * 0.6;
    }
    pos.x -= ySize;
    //PRINTF(0)("secweaponwidget y-size: %f/n", (*weaponWidget)->getSizeY2D());
    (*weaponWidget)->setAbsCoor2D(pos.x + this->rightRect->getAbsCoor2D().x, pos.y);
    (*weaponWidget)->show();
    //printf("update thing %s::%s\n", (*weaponWidget)->getClassCName(), (*weaponWidget)->getName());
  }

}

void Hud::draw() const
{
  //  GLGuiWidget::draw();
}


void Hud::process(const Event &event)
{
  if (event.type == EV_VIDEO_RESIZE)
    this->updateResolution();
  else if (event.type == SDLK_TAB)
  {
    /// TODO SHOW THE INPUT-LINE
  //  this->inputLine->select();
  }
}

/*
void Hud::createShipValuesBox()
{
  this->shipValuesBox = new OrxGui::GLGuiBox(OrxGui::Vertical);
  //this->shipValuesBox->setWidgetSize(1000,500);
  //this->shipValuesBox->setBackgroundTexture("textures/gui_container_background.png");
  this->shipValuesBox->setBackgroundTexture(Texture());
  this->shipValuesBox->setBackgroundColor(Color(0,0,1,0.5));
  this->shipValuesBox->setVisibility(true);
}
*/


