
#ifndef _NPC_H
#define _NPC_H

#include "world_entity.h"
#include "ai_module.h"
#include "world_entities/weapons/weapon_manager.h"

class AI;

class NPC : public WorldEntity
{
  ObjectListDeclaration(NPC);

public:
  NPC(const TiXmlElement* root = NULL);
  virtual ~NPC ();

  virtual void loadParams(const TiXmlElement* root);


  void addWeapons(const TiXmlElement* root);
  bool addWeapon(Weapon* weapon, int configID = -1, int slotID = -1);
  void removeWeapon(Weapon* weapon);
  void nextWeaponConfig();
  void previousWeaponConfig();
  inline WeaponManager& getWeaponManager() { return this->weaponMan; };


  virtual void tick(float dt);
  void draw() const;
  inline int getTeam()  { return teamNumber; }
  inline void fire(){ this->bFire=true;}

  inline void enableAI() { this->bAIEnabled = true; }

private:
  inline void setTeamNumber(int number) { teamNumber=number; }
  inline void setSwarmNumber(int number) { swarmNumber=number; }
  inline void setMaxSpeed(float number) { maxSpeed=number; }
  inline void setAttackDistance(float number) { attackDistance=number; }

 private:

  int                   teamNumber;   //!< number of the team
  int                   swarmNumber;  //!< number of the swarm
  int                   difficulty;   //!< difficulty
  float						maxSpeed;
  float						attackDistance;

  WeaponManager         weaponMan;    //!< weapon manager
  bool                  bFire;        //!< fire

  AIModule*             aiModule;

  bool                  bAIEnabled;   //!< true is AI enabled
};

#endif /* _NPC_H */
