/*!
 * @file blink.h
 */
 /*! example input in .oxw file with the standard values

<Blink>
  <name>Blink1</name>
  <position>580, 70, -130</position>
  <color>0, 255, 255</color>
  <size>8</size>
  <period>9</period>
  <sequence>0123456789</sequence><!-- the number describe the strength of the blink light -->
</Blink>

*/

#ifndef _BLINK_H
#define _BLINK_H

#include "world_entity.h"
#include "effects/billboard.h"
#include "color.h"

class Material;
class TiXmlElement;
//class Billboard;

class Blink : public WorldEntity
{
  ObjectListDeclaration(Blink);
  public:
    Blink(const TiXmlElement* root = NULL);
    virtual ~Blink();

    void init();
    void loadParams(const TiXmlElement* root);

    void setPosition(float x, float y, float z) { this->bBoard->setAbsCoor(x, y, z); }
    void setSize(float s) { this->size = s; this->bBoard->setSize(this->size, this->size); }
    void setPeriod(float t) { this->period = t; }
    void setColor(float r, float g, float b) { this->color = Color(r/255, g/255, b/255); }
    void loadBlinkSequence(const std::string& seq) { this->blinkSequence = seq; }

    virtual void tick(float dt);
    virtual void draw() const;

  private:
    Billboard*        bBoard;
    Color             color;
    std::string       blinkSequence;    //! 1 means fully viewable, 0 means fully transparent
    float             angle;
    float             period;           //! period in seconds
    float             blinkStr;
    float             size;             //! only one float caus' its quadratical
    int               seqCounter;
    float             symbolTime;       //! defines how long one symbol of the sequence will be shown in sec
    float             timer;
};

#endif /* _BLINK_H */
