/*

   Copyright (C) 2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Lieni
*/

#include "blink.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"
#include "debug.h"
#include "state.h"
#include "effects/billboard.h"




ObjectListDefinition(Blink);
CREATE_FACTORY(Blink);

/**
 * standart constructor
 */
Blink::Blink (const TiXmlElement* root)
{
  this->init();

  if(root)
    this->loadParams(root);

  // calculation of the symbolTime
  this->symbolTime = this->period / this->blinkSequence.length();
}


/**
 * destroys a Blink
 */
Blink::~Blink ()
{
  if(bBoard)
    delete bBoard;
}


/**
 * initializes the Blink
 */
void Blink::init()
{
  this->registerObject(this, Blink::_objectList);
  this->setName("Blink");

  this->toList(OM_COMMON);

  this->bBoard = new Billboard;
  this->bBoard->setVisibiliy(true);
  this->bBoard->setTexture("textures/light/blink.png");

  /// Standard values
  this->bBoard->setAbsCoor(0, 0, 0);
  // default position if not set in xml
  this->color = Color(1, 0, 0);
  // 10x10 pxl if not defined in xml
  this->size = 10;
  // default period
  this->period = 1;
  // default blink sequence
  this->blinkSequence = "00011234567889998876543211";

  // start values of non-loadable variables
  this->blinkStr = 0;
  this->timer = 0;
  this->seqCounter = 0;
}


/**
 *  load params
 * @param root TiXmlElement object
 */
void Blink::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);

  LoadParam(root, "position", this, Blink, setPosition);
  LoadParam(root, "size", this, Blink, setSize);
  LoadParam(root, "color", this, Blink, setColor);
  LoadParam(root, "period", this, Blink, setPeriod);
  LoadParam(root, "sequence", this, Blink, loadBlinkSequence);
}


/**
 * ticks the Blink
 * @param dt the time to ticks
 */
void Blink::tick(float dt)
{
  timer += dt;

  while(this->timer >= this->symbolTime)
  {
    this->blinkStr = (float)((int)(blinkSequence[seqCounter]) - 48) / 9;

    this->timer -= symbolTime;

    seqCounter++;
    seqCounter %= this->blinkSequence.length();
  }

  this->bBoard->colorTexture(Color(color.r(), color.g(), color.b(), this->blinkStr));
}


/**
 * draws the blink
 */
void Blink::draw() const
{

}
