/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "network_stats_widget.h"
#include "network_monitor.h"
#include "peer_info.h"

#include "loading/resource_manager.h"

#include "multi_type.h"

#include "shell_command.h"

// this fcuk does not work!
// SHELL_COMMAND(gui, NetworkStatsWidget, toggleGUI)
// ->setAlias("ProxyGui");

HostWidget::HostWidget(const std::string& name, const IP& ip)
    : GLGuiBox(OrxGui::Horizontal)
{
  this->init();

  this->setName(name);
  this->setIP(ip);

}

HostWidget::HostWidget(const PeerInfo* peerInfo)
    : GLGuiBox(OrxGui::Horizontal)
{
  this->init();
  if (peerInfo == NULL)
  {
    this->setName("INVALID");
    return;
  }
  this->setName(peerInfo->getNodeTypeString() + "ID: " + MultiType(peerInfo->userId).getString());
  this->setIP(peerInfo->ip);
}

void HostWidget::init()
{
  if(_font == NULL)
    _font = new Font(Resources::ResourceManager::getInstance()->mainGlobalPath().name() + "/fonts/final_frontier.ttf", 20);

  //this->_name.setFont(*_font);
  this->_name.setTextSize(15);
  //this->_ip.setFont(*_font);
  this->_ip.setTextSize(15);

  this->pack(&this->_name);
  this->pack(&this->_ip);
}

void HostWidget::showing()
{
  this->_name.show();
  this->_ip.show();
}

void HostWidget::hiding()
{
  this->_name.hide();
  this->_ip.hide();
}

Font* HostWidget::_font = NULL;




//======================================================//


NodeWidget::NodeWidget(const std::string& proxyName, const IP& ip)
    : _proxyWidget(proxyName, ip)
{
  this->_nodeNameWidth = 100.0f;
  this->pack(&_proxyWidget);
}

NodeWidget::NodeWidget(const NetworkNode* node)
    : _proxyWidget(node->getPeerInfo())// "node", node->getPeerInfo()->ip)
{
  this->_nodeNameWidth = 100.0f;
  this->pack(&_proxyWidget);

  std::list<NetworkNode*> list = node->getMasterServers();
  std::list<NetworkNode*>::const_iterator it;

  for(it = list.begin(); it != list.end(); it++)
    this->addNode(*it);

  list = node->getActiveProxyServers();
  for(it = list.begin(); it != list.end(); it++)
    this->addNode(*it);

  list = node->getPassiveProxyServers();
  for(it = list.begin(); it != list.end(); it++)
    this->addNode(*it);

  list = node->getClients();
  for(it = list.begin(); it != list.end(); it++)
    this->addNode(*it);
}


void NodeWidget::addNode(const NetworkNode* node)
{
  this->_nodes.push_back(new NodeWidget(node));
  this->pack(this->_nodes.back());
  this->_nodes.back()->show();
}


void NodeWidget::addNode(const std::string& name, const IP& ip)
{
  HostWidget* newClient = new HostWidget(name, ip);
  newClient->setNameWidth(this->_nodeNameWidth);

  this->pack(newClient);

  if (this->isVisible())
    newClient->show();
}

bool NodeWidget::removeNode(const IP& ip)
{
//   std::vector<HostWidget*>::iterator rmIt;
//   for(rmIt = this->_nodes.begin(); rmIt != this->_nodes.end(); ++rmIt)
//   {
//     if (*(*rmIt) == ip)
//     {
//       delete (*rmIt);
//       this->_nodes.erase(rmIt);
//       return true;
//     }
//   }
//   return false;
}

bool NodeWidget::removeNode(const std::string& name)
{
//   std::vector<HostWidget*>::iterator rmIt;
//   for(rmIt = this->_nodes.begin(); rmIt != this->_nodes.end(); ++rmIt)
//   {
//     if (*(*rmIt) == name)
//     {
//       delete (*rmIt);
//       this->_nodes.erase(rmIt);
//       return true;
//     }
//   }
//   return false;

}

bool NodeWidget::removeNode(const std::string& name, const IP& ip)
{
//   std::vector<HostWidget*>::iterator rmIt;
//   for(rmIt = this->_nodes.begin(); rmIt != this->_nodes.end(); ++rmIt)
//   {
//     if (*(*rmIt) == ip && *(*rmIt) == name)
//     {
//       delete (*rmIt);
//       this->_nodes.erase(rmIt);
//       return true;
//     }
//   }
//   return false;
}


void NodeWidget::setNodeNameWidths(float width)
{
/*  this->_nodeNameWidth = width;
  for (unsigned int i = 0; i < this->_nodes.size(); ++i)
    this->_nodes[i]->setNameWidth(width);*/
}

void NodeWidget::hiding()
{
  this->_proxyWidget.hide();
  for (unsigned int i = 0; i < this->_nodes.size(); ++i)
    this->_nodes[i]->hide();
}

void NodeWidget::showing()
{
  this->_proxyWidget.show();
  for (unsigned int i = 0; i < this->_nodes.size(); ++i)
    this->_nodes[i]->show();
}


//======================================================//


ObjectListDefinition(NetworkStatsWidget);
/**
 * @brief standard constructor
 */
NetworkStatsWidget::NetworkStatsWidget(const NetworkMonitor* monitor)
    : OrxGui::GLGuiFixedpositionBox(OrxGui::Center, OrxGui::Vertical), _thisHost("myName", IP(127, 0, 0 , 1))
{
  this->_monitor = monitor;
  this->_passedTime = 0.0f;

  /*
  this->_bar.setSize2D(100, 30);
  this->pack(&this->_valueText);
  this->_bar.setParent2D(&this->_valueText);

  this->_valueText.setChangedTextColor(Color::white);

  //this->setBackgroundTexture("textures/gui_element_background_2.png");
  this->setBackgroundColor(Color(.5,.5,.5,1));

  //this->_name.setBackgroundTexture(Texture());
  //this->_valueText.setBackgroundTexture("textures/gui_element_background_2.png");
  this->_bar.setBackgroundTexture(Texture());
  this->_bar.setBackgroundColor(Color(0,0,0,0));
  this->_bar.setForegroundTexture("textures/gui_element_background_faded.png");
  this->_bar.setForegroundColor(Color(.5, .5, .5, 1));
  this->_bar.setChangedValueColor(Color::black);
  */
  this->_thisHostIs.setText(std::string("I am ") + _monitor->getLocalNode()->getPeerInfo()->getNodeTypeString());

  this->pack(&this->_thisHostIs);

  this->pack(&this->_thisHost);

  this->pack(&this->_serverBox);

  this->pack(&this->_upstreamText);
  this->pack(&this->_downstreamText);


  this->rebuild();
}


/**
 * @brief standard deconstructor
 */
NetworkStatsWidget::~NetworkStatsWidget ()
{}


void NetworkStatsWidget::addNode(const NetworkNode* node)
{
  this->_proxies.push_back(new NodeWidget(node));
  this->_serverBox.pack(this->_proxies.back());
  this->_proxies.back()->show();
}




NetworkStatsWidget* NetworkStatsWidget::_statsWidget = NULL;

void NetworkStatsWidget::toggleGUI()
{
  NetworkMonitor* monitor;
  if (!NetworkMonitor::objectList().empty())
    monitor = NetworkMonitor::objectList().front();

  if (monitor != NULL && NetworkStatsWidget::_statsWidget == NULL)
  {
    NetworkStatsWidget::_statsWidget = new NetworkStatsWidget(monitor);
    NetworkStatsWidget::_statsWidget->showAll();
  }
  else
  {
    delete NetworkStatsWidget::_statsWidget;
    NetworkStatsWidget::_statsWidget = NULL;
  }
}


void NetworkStatsWidget::setMaximum(float max)
{
  // this->_bar.setMaximum(max);
}

void NetworkStatsWidget::setValue(float value)
{
  MultiType val(value);
  val.setType(MT_INT);
  /*

  this->_bar.setValue(value);
  this->_bar.setForegroundColor(Color::slerpHSVColor(Color::red, Color::green, value/this->_bar.maximum()));
  this->_bar.setFrontColor(Color(1,1,1,1), true);
  this->_valueText.setText(val.getString());
  */
}


void NetworkStatsWidget::addProxy(const std::string& name, const IP& proxy)
{}

void NetworkStatsWidget::clearProxies()
{}


void NetworkStatsWidget::rebuild()
{
  while (!this->_proxies.empty())
  {
    delete this->_proxies.back();
    this->_proxies.pop_back();
  }

  const NetworkNode* node = this->_monitor->getLocalNode();
  if (node == NULL)
  {
    printf("NO NODE\n");
    return;
  }

  this->addNode(node);
}



void NetworkStatsWidget::tick(float dt)
{

  if ((_passedTime+= dt) > 1.0f)
  {
    this->_passedTime = 0.0f;
    this->rebuild();
  }

  assert (this->_monitor->getLocalNode() != NULL);
  assert(this->_monitor->getLocalNode()->getPeerInfo() != NULL);

  if(this->_monitor->getLocalNode()->getPeerInfo()->connectionMonitor != NULL)
  {
    ConnectionMonitor* mon = this->_monitor->getLocalNode()->getPeerInfo()->connectionMonitor;

    this->_upstreamText.setText(MultiType(mon->getOutgoingZippedBandWidth()).getString());
    this->_downstreamText.setText(MultiType(mon->getIncomingZippedBandWidth()).getString());
  }
}

void NetworkStatsWidget::resize()
{
  GLGuiFixedpositionBox::resize();
}


void NetworkStatsWidget::showing()
{}

void NetworkStatsWidget::hiding()
{}
