/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Filip Gospodinov
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "executor/executor.h"
#include "util/loading/factory.h"
#include "util/loading/load_param.h"
#include "blackscreen.h"
#include "debug.h"
#include "material.h"
#include "state.h"
// #include "camera.h"
#include "primitive_model.h"

ObjectListDefinition(BlackScreen);
CREATE_FACTORY(BlackScreen);



/**
 *
 */
BlackScreen::BlackScreen()
{
  this->init();


}


/**
 *
 */
BlackScreen::BlackScreen(const TiXmlElement* root)
{
  this->init();

  if( root != NULL)
    this->loadParams(root);

}


/**
 *
 */
BlackScreen::~BlackScreen()
{}


/**
 *
 */
void BlackScreen::init()
{
  this->registerObject(this, BlackScreen::_objectList);
  this->toList(OM_GROUP_00);

  this->material = new Material();
  this->material->setDiffuse(0,0,0);
  this->material->setBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

  PrimitiveModel* model = new PrimitiveModel(PRIM_SPHERE, 6., 10);
  this->setModel(model);

  i=0;
  state=0;
  fadeSpeed=1;

}


/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void BlackScreen::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);
}




void BlackScreen::draw() const
{
  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_LIGHTING);
  glEnable(GL_BLEND);   // Turn Blending On

//   glMatrixMode(GL_MODELVIEW);
//   glPushMatrix();
//   /* translate */
//   glTranslatef (this->getAbsCoor ().x,
//                 this->getAbsCoor ().y,
//                 this->getAbsCoor ().z);
//   Vector tmpRot = this->getAbsDir().getSpacialAxis();
//   glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

  this->material->select();


  WorldEntity::draw(this->getModel( ));

//   glBegin(GL_QUADS);

//   glVertex3f(0.,-100.0f,-100.0f);
//   glVertex3f(0., -100.0f,100.0f);
//   glVertex3f(0., 100.0f,100.0f);
//   glVertex3f(0., 100.0f,-100.0f);

//   glEnd();

  glPopMatrix();
  glPopAttrib();
}

/**
 *
 */
void BlackScreen::tick (float time)
{
if (state == true)
  fadeOut();
else
  fadeIn();

  this->material->setTransparency(i);
//   Camera* cam = State::getCamera();
//   if( cam != NULL)
//     this->setParent(cam);
}

void BlackScreen::fadeIn()
{
  if (i>0)
    i=i-0.005*fadeSpeed;
  else
    this->toList(OM_DEAD);
}

void BlackScreen::fadeOut()
{
  if (i<=1)
    i=i+0.005*fadeSpeed;
}

void  BlackScreen::toggleFade ()
{
    this->state= !this->state;

    if(state)
    {
      this->toList(OM_COMMON);
    }
}

void BlackScreen::changeFadeSpeed(float newSpeed)
{
  fadeSpeed=newSpeed;
}

bool BlackScreen::isBlack()
{
if (i==1)
  return 1;
else
  return 0;
}

bool BlackScreen::isTrans()
{
  if (i==0)
    return 1;
  else
    return 0;
}
