/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Filip Gospodinov
   co-programmer: Silvan Nellen
*/

#include "shell_command.h"
#include "cameraman.h"
#include "game_world_data.h"
#include "state.h"
#include "sound_engine.h"
#include <string>
#include "script_class.h"
#include "loading/load_param_xml.h"

ObjectListDefinition(CameraMan);


CREATE_SCRIPTABLE_CLASS(CameraMan,
                        addMethod("changeCurrTarget", Executor2<CameraMan, lua_State*,const std::string&,const std::string&>(&CameraMan::changeCurrTarget))
                        ->addMethod("changeTarget", Executor3<CameraMan, lua_State*, const std::string&, const std::string&,const std::string&>(&CameraMan::changeTarget))
                        ->addMethod("setCam", Executor1<CameraMan, lua_State*, const std::string&>(&CameraMan::setCam))
                        ->addMethod("togglFade", Executor0<CameraMan, lua_State*>(&CameraMan::togglFade))
                        ->addMethod("getCurrCameraCoorX", Executor0ret<CameraMan, lua_State*,float>(&CameraMan::getCurrCameraCoorX))
                        ->addMethod("getCurrCameraCoorY", Executor0ret<CameraMan, lua_State*,float>(&CameraMan::getCurrCameraCoorY))
                        ->addMethod("getCurrCameraCoorZ", Executor0ret<CameraMan, lua_State*,float>(&CameraMan::getCurrCameraCoorZ))
                       );


CameraMan::CameraMan(const TiXmlElement* root)
{
  this->registerObject(this, CameraMan::_objectList);

  this->nearClip = 1.0;
  this->farClip = 1000.0;

  this->fadeToBlack=new BlackScreen();

  this->setCam( State::getCamera());

  if (root != NULL)
    this->loadParams(root);
}


void CameraMan::loadParams(const TiXmlElement* root)
{
  BaseObject::loadParams(root);

  LOAD_PARAM_START_CYCLE(root, object);
  {
    this->createCam(object);
  }
  LOAD_PARAM_END_CYCLE(object);

}


void CameraMan::createCam(const TiXmlElement* root)
{
  //Camera* newCamera=new Camera(root);
  this->cameras.push_back(new Camera(root));
  cameras[cameras.size()-1]->target->detach();
  cameras[cameras.size()-1]->setClipRegion(nearClip, farClip);

}

void CameraMan::setCam(int cameraNo)
{
  if (cameraNo<cameras.size())
  {
    this->setCam( cameras[cameraNo]);
  }
}

void CameraMan::setCam(const std::string& camName)
{
  BaseObject* object = ObjectListBase::getBaseObject("Camera", camName);

  if(object != NULL)
  {
    Camera* currentCam = dynamic_cast<Camera*>(object) ;

    this->setCam(currentCam);
    return;
  }
  printf("ERROR CAMERAMANAGER: Couldn't set camera : %s \n", camName.c_str());
}


void CameraMan::setCam(Camera* camera)
{
  if( camera == NULL)
  {
    PRINTF(0)("trying to add a zero camera! uiuiui!\n");
  }
  this->currentCam = camera;

  State::setCamera(currentCam, currentCam->getTarget());
  OrxSound::SoundEngine::getInstance()->setListener(currentCam);

  // check if it is already added
  if( ! this->cameraIsInVector(currentCam) )
    this->cameras.push_back(currentCam);

  this->fadeToBlack->setRelCoor(0., 0., 0.);
  this->fadeToBlack->setParent(this->currentCam);
}


void CameraMan::moveCurrCam(int x, int y, int z)
{
  currentCam->target->trans(x,y,z);
}


void CameraMan::moveCam(int x, int y, int z, int camNo)
{
  cameras[camNo]->target->trans(x,y,z);
}


void CameraMan::changeTarget(int camNo,const std::string& className, const std::string& objectName)
{
  BaseObject* object = ObjectListBase::getBaseObject(className, objectName);
  if( object != NULL && object->isA(PNode::staticClassID()))
    cameras[camNo]->lookAt(dynamic_cast<PNode*>(object));
}


void CameraMan::changeTarget(const std::string& camName,const std::string& className, const std::string& objectName)
{
  BaseObject* object = ObjectListBase::getBaseObject(className, objectName);
  BaseObject* newCam = ObjectListBase::getBaseObject("Camera", camName);
  if( object != NULL && newCam != NULL && object->isA(PNode::staticClassID()))
    dynamic_cast<Camera*>(newCam)->lookAt(dynamic_cast<PNode*>(object));
}

void CameraMan::changeCurrTarget(const std::string& className, const std::string& objectName)
{
  BaseObject* object = ObjectListBase::getBaseObject(className, objectName);
  if( object != NULL && object->isA(PNode::staticClassID()))
    currentCam->lookAt(dynamic_cast<PNode*>(object));
}

void CameraMan::atachCurrTarget(PNode* target)
{
  currentCam->target->atach(target);
}

void CameraMan::jumpCam(int x, int y, int z, int camNo)
{
  cameras[camNo]->target->jump(x, y, z);
}



void CameraMan::setClipRegion(float nearCli, float farCli)
{
  this->nearClip=nearCli;
  this->farClip=farCli;

  for(int i = 0; i < this->cameras.size(); i++)
    cameras[i]->setClipRegion(nearCli, farCli);
}


void CameraMan::jumpCurrCam(int x, int y, int z)
{
  currentCam->target->jump(x, y, z);
}




void CameraMan::togglFade()
{
  if( this->fadeToBlack)
    fadeToBlack->toggleFade();
}



bool CameraMan::cameraIsInVector(Camera* camera)
{

  for(std::vector<Camera*>::const_iterator it = cameras.begin(); it != cameras.end(); it++ )
  {
    if( (*it) == camera)
    {
      return true;
    }
  }
  return false;


}


//how to get a class fkt pointer

//BaseObject* object = ObjectListBase::getBaseObject(className, objectName);














