#ifndef _CAMERAMAN_H
#define _CAMERAMAN_H

#include "p_node.h"
#include "camera.h"
#include <vector>
#include "base_object.h"
#include "blackscreen.h"

class CameraMan : public BaseObject {
  ObjectListDeclaration(CameraMan);

  private:
    Camera* currentCam;
    float nearClip;
    float farClip;
    BlackScreen* fadeToBlack;

  public:
    std::vector<Camera*> cameras;
    CameraMan(const TiXmlElement* root = NULL);
    void setCam(int CameraNo);
    void setCam(const std::string& camName);
    void createCam(const TiXmlElement* root);
    void moveCam(int x, int y, int z,  int camNo);
    void moveCurrCam(int x, int y, int z);
    void changeTarget(int camNo, const std::string& className,const std::string& objectName);
    void changeTarget(const std::string& camName,const std::string& className, const std::string& objectName);
    void changeCurrTarget(const std::string& className, const std::string& objectName);
    void atachCurrTarget(PNode* target);
    void jumpCam(int x, int y, int z, int camNo);
    void jumpCurrCam(int x, int y, int z);
    void changeSpeed(float speed);
    void setClipRegion(float nearClip, float farClip);
    void togglFade();
    
    /// LOADING
    virtual void loadParams(const TiXmlElement* root);
    
    /// POLLING
    float getCurrCameraCoorX(){ return this->currentCam->getAbsCoorX(); }
    float getCurrCameraCoorY(){ return this->currentCam->getAbsCoorY(); }
    float getCurrCameraCoorZ(){ return this->currentCam->getAbsCoorZ(); }
    bool cameraIsInVector(Camera* camera);

};

#endif /* _CAMERAMAN_H */
