/*!
 * @file planet.h
 *  Definition of the Planet, that handles the Display of an atmosphere for orxonox.
 */

#ifndef _PLANET_H
#define _PLANET_H

/* INCLUDES */
#include "world_entity.h"
#include "material.h"
/* FORWARD DECLARATION */
class Texture;

//! A Class to handle a Planet
class Planet : public WorldEntity
{
  ObjectListDeclaration(Planet);

 public:
  Planet(const TiXmlElement* root);

  virtual ~Planet();

  virtual void loadParams(const TiXmlElement* root);

  void setSize(float size);
  /** assumes jpg as input-format */
  void setTexture(const std::string& textureName);
  void setCloudTexture(const std::string& textureName);
  void setCloudRotation(float rotationSpeed);



  virtual void tick( float dt);
  virtual void draw() const;



 private:
  Material        materialPlanet;  //!< Materials for the Planet. sorted by number (0-5) top, bottom, left, right, front, back
  Material        materialCloud;   //!< the material for the cloud surrounding the planet

  Model*          cloudModel;      //!< the model for the cloud

  float           rotSpeedCloud;   //! cloud rotation speed
  float           rotSpeedPlanet;  //! planet rotation speed
  float           size;            //!< Size of the Planet. This should match the frustum maximum range.
  float           textureSize;     //!< this is the length of a texture (assumes a square texture)
  char*           textureName;     //!< Name of the Texture

};

#endif  /* _PLANET_H */



