#ifndef _CAMERAMAN_H
#define _CAMERAMAN_H

#include "p_node.h"
#include "camera.h"
#include <vector>
#include "base_object.h"
#include "blackscreen.h"

class CameraMan : public BaseObject {
  ObjectListDeclaration(CameraMan);

  private:
    Camera* currentCam;
    float nearClip;
    float farClip;
    BlackScreen* fadeToBlack;

  public:
    std::vector<Camera*> cameras;
    CameraMan();
    void setCam(int CameraNo);
    void createCam();
    void moveCam(int x, int y, int z,  int camNo);
    void moveCurrCam(int x, int y, int z);
    void changeTarget(int camNo, std::string className, std::string objectName);
    void changeCurrTarget(std::string className, std::string objectName);
    void atachCurrTarget(PNode* target);
    void jumpCam(int x, int y, int z, int camNo);
    void jumpCurrCam(int x, int y, int z);
    void changeSpeed(float speed);
    void setClipRegion(float nearClip, float farClip);
    void togglFade();

};

#endif /* _CAMERAMAN_H */
