/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Filip Gospodinov
   co-programmer:
*/

#include "shell_command.h"
#include "cameraman.h"
#include "game_world_data.h"
#include "state.h"
#include "sound_engine.h"
#include <string>

ObjectListDefinition(CameraMan);


CameraMan::CameraMan()
{
  this->registerObject(this, CameraMan::_objectList);

  this->nearClip = 1.0;
  this->farClip = 1000.0;

  currentCam=State::getCamera();
  this->cameras.push_back(currentCam);
  State::setCamera(currentCam, currentCam->getTarget());
  this->fadeToBlack=new BlackScreen();
}


void CameraMan::createCam()
{
 // Camera* newCamera=new Camera();
  this->cameras.push_back(new Camera());
  cameras[cameras.size()-1]->target->detach();
  cameras[cameras.size()-1]->setClipRegion(nearClip, farClip);

}

void CameraMan::setCam(int cameraNo)
{
  if (cameraNo<cameras.size())
  {
  currentCam=cameras[cameraNo];
  State::setCamera(currentCam, currentCam->getTarget());
  OrxSound::SoundEngine::getInstance()->setListener(currentCam);

  this->fadeToBlack->setParent(this->currentCam);
  this->fadeToBlack->setRelCoor(3., 0., 0.);
  }

}



void CameraMan::moveCurrCam(int x, int y, int z)
{
currentCam->target->trans(x,y,z);
}


void CameraMan::moveCam(int x, int y, int z, int camNo)
{
cameras[camNo]->target->trans(x,y,z);
}


void CameraMan::changeTarget(int camNo, std::string className, std::string objectName)
{
  BaseObject* object = ObjectListBase::getBaseObject(className, objectName);
  if( object != NULL && object->isA(PNode::staticClassID()))
    cameras[camNo]->lookAt(dynamic_cast<PNode*>(object));
}


void CameraMan::changeCurrTarget(std::string className, std::string objectName)
{
  BaseObject* object = ObjectListBase::getBaseObject(className, objectName);
  if( object != NULL && object->isA(PNode::staticClassID()))
    currentCam->lookAt(dynamic_cast<PNode*>(object));
}

void CameraMan::atachCurrTarget(PNode* target)
{
  currentCam->target->atach(target);
}

void CameraMan::jumpCam(int x, int y, int z, int camNo)
{
  cameras[camNo]->target->jump(x, y, z);
}



void CameraMan::setClipRegion(float nearCli, float farCli)
{
  this->nearClip=nearCli;
  this->farClip=farCli;

  for(int i = 0; i < this->cameras.size(); i++)
    cameras[i]->setClipRegion(nearCli, farCli);
}


void CameraMan::jumpCurrCam(int x, int y, int z)
{
  currentCam->target->jump(x, y, z);
}




void CameraMan::togglFade()
{
  if( this->fadeToBlack)
    fadeToBlack->toggleFade();
}



//how to get a class fkt pointer

//BaseObject* object = ObjectListBase::getBaseObject(className, objectName);














