/*!
 * @file game_world_data.h
 *  container for all game world data
 */

#ifndef _GAME_WORLD_DATA_H
#define _GAME_WORLD_DATA_H

#include "sdlincl.h"
#include "data_tank.h"
#include "error.h"
#include "object_manager.h"

class Camera;
class Player;
class Terrain;
class WorldEntity;

class GLMenuImageScreen;

namespace OrxSound {class OggPlayer;}
class GameRules;


//! The game world data
/**
 * this class is a containter for the data of the GameWorld. It just loads and unloads it
 * the game start/stop process is not contained here and can be found in the GameWorld class.
 */
class GameWorldData : public DataTank
{
  ObjectListDeclaration(GameWorldData);
  public:
    GameWorldData();
    virtual ~GameWorldData();

    virtual ErrorMessage init();
    virtual ErrorMessage loadData(const TiXmlElement* root);
    virtual ErrorMessage unloadData();

    /* interface functions */
    void setSoundTrack(const std::string& name);
    void loadGameRule(const TiXmlElement* root);


  protected:
    virtual ErrorMessage loadGUI(const TiXmlElement* root);
    virtual ErrorMessage loadWorldEntities(const TiXmlElement* root);
    virtual ErrorMessage loadScene(const TiXmlElement* root);

    virtual ErrorMessage unloadGUI();
    virtual ErrorMessage unloadWorldEntities();
    virtual ErrorMessage unloadScene();

  public:
    GLMenuImageScreen*            glmis;          //!< The Level-Loader Display


    Player*                       localPlayer;    //!< The player, you fly through the level.
    WorldEntity*                  sky;            //!< The environmental sky of orxonox
    Terrain*                      terrain;        //!< The terrain - ground

    OrxSound::OggPlayer*          music;          //!< Reference to the SoundEngine's music player (OggPlayer)
    ObjectManager*                objectManager;  //!< Reference to the objects manager

    GameRules*                    gameRule;       //!< Reference to the game rules of this game

    std::vector<OM_LIST>          tickLists;      //!< The Lists in the GameWorld that should be ticked.
    std::vector<OM_LIST>          drawLists;      //!< The Lists in the GameWorld, that should be drawn.
};

#endif /* _GAME_WORLD_DATA_H */

