/*!
 * @file glgui_multiline_text.h
 * The gl_TEXT widget of th openglGUI
 *
 */

#ifndef _GLGUI_MULTILINE_TEXT_H
#define _GLGUI_MULTILINE_TEXT_H

#include "glgui_widget.h"
#include "multi_line_text.h"
// FORWARD DECLARATION
namespace OrxGui
{

  //! This is part of the openglGUI class
  /**
   *
   */
  class GLGuiMultiLineText : public GLGuiWidget
  {
    ObjectListDeclaration(GLGuiMultiLineText);
  public:
    GLGuiMultiLineText();
    virtual ~GLGuiMultiLineText();

    void setText(const std::string& text);
    void append(const std::string& appendText);
    void appendCharacter(char character);
    void removeCharacters(unsigned int chars);
    void clear();

    void setTextSize(float size);
    virtual void setFont(const Font& font);
    void setChangedTextColor(const Color& color);

    void setLineWidth(float lineWidth) { this->_text.setLineWidth(lineWidth); };
//    void setDotsPosition(LimitedWidthText::DotsPosition dotsPosition) { this->_text.setDotsPosition(dotsPosition); };

    const std::string& text() const { return _text.text(); };


    virtual void draw() const;

    sigslot::signal1<const std::string&> textChanged;

  protected:
    virtual void updateFrontColor();
    virtual void hiding();
    virtual void showing();
    virtual void resize();

  private:
    void init();
    void changedText();


  private:
    MultiLineText       _text;

    Color               _changedTextColor;
  };
}

#endif /* _GLGUI_MULTILINE_TEXT_H */
