/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_multiline_text.h"

#include "text.h"

namespace OrxGui
{
  ObjectListDefinition(GLGuiMultiLineText);
  /**
   * standard constructor
  */
  GLGuiMultiLineText::GLGuiMultiLineText ()
  {
    this->init();

  }


  /**
   * standard deconstructor
  */
  GLGuiMultiLineText::~GLGuiMultiLineText()
  {}

  /**
   * initializes the GUI-element
   */
  void GLGuiMultiLineText::init()
  {
    this->registerObject(this, GLGuiMultiLineText::_objectList);

    this->_text.setParent2D(this);
    this->_text.setRelCoor2D(4,4);
    this->_text.setFont("fonts/final_frontier.ttf", 20);
    this->_text.setLineWidth(400);
//     this->_text.setDotsPosition(LimitedWidthText::Begin);
    this->_text.setColor(foregroundColor());
    this->_text.setVisibility(false);
    this->_changedTextColor = Color::white;
    this->resize();
  }

  /**
  * @brief sets the Text of the Text
  * @param text The new Text.
   */
  void GLGuiMultiLineText::setText(const std::string& text)
  {
    this->_text.setText(text);
    this->changedText();
  }

  /**
   * @brief appends text to the Text
   * @param appendText the Text to append
   */
  void GLGuiMultiLineText::append(const std::string& appendText)
  {
    this->_text.append(appendText);
    this->changedText();
  }


  /**
   * @brief appends a Character to the Text
   * @param character the Character to append.
   */
  void GLGuiMultiLineText::appendCharacter(char character)
  {
    this->_text.appendCharacter(character);
    this->changedText();
  }


  /**
   * @brief Removes Characters from the Text
   * @param chars The count of characters to remove
   */
  void GLGuiMultiLineText::removeCharacters(unsigned int chars)
  {
    this->_text.removeCharacters(chars);
    this->changedText();
  }

  void GLGuiMultiLineText::clear()
  {
    this->_text.clear();
    this->resize();
  }


  /**
  * @brief If the Text has been changed this function is called.
  *
  * This Function also emits the Signal textChanged.
   */
  void GLGuiMultiLineText::changedText()
  {
    this->resize();
    this->setFrontColor(_changedTextColor, true);
    this->textChanged.emit(this->_text.text());
  }

  void GLGuiMultiLineText::setTextSize(float size)
  {
    this->_text.setSize(size);
    this->changedText();
  }

  void GLGuiMultiLineText::setFont(const Font& font)
  {
    GLGuiWidget::setFont(font);
    this->_text.setFont(font);
  }

  void GLGuiMultiLineText::setChangedTextColor(const Color& color)
  {
    this->_changedTextColor = color;
  }

  /**
   * @brief Resizes the Widget to the new Size-constraints.
   */
  void GLGuiMultiLineText::resize()
  {
    this->_text.setRelCoor2D(borderLeft(), borderTop());
    this->setSize2D( this->_text.getSize2D() + Vector2D(borderLeft() + borderRight(), borderTop() + borderBottom()));
    //this->_text.setLineWidth(this->size2D);
    GLGuiWidget::resize();
    /*    this->frontRect().setTopLeft(borderLeft(), borderTop());
    this->frontRect().setSize(this->getSize2D() - Vector2D(borderLeft() + borderRight(), borderTop() + borderBottom()));*/
  }

  void GLGuiMultiLineText::updateFrontColor()
  {
    this->_text.setColor(foregroundColor());
  }

  void GLGuiMultiLineText::hiding()
  {
    this->_text.setVisibility(false);
  }

  void GLGuiMultiLineText::showing()
  {
    this->_text.setVisibility(true);
  }



  /**
   * draws the GLGuiMultiLineText
   */
  void GLGuiMultiLineText::draw() const
  {
    this->beginDraw();
    GLGuiWidget::draw();

    //     this->frontMaterial().select();
    //     GLGuiWidget::drawRect(this->frontRect());

    this->endDraw();
  }
}
