
#ifndef _QUEST_H
#define _QUEST_H



#include "base_object.h"
#include <string>

class Quest : public BaseObject 
{

  ObjectListDeclaration(Quest);
  
  public:
   Quest (const TiXmlElement* root);
   virtual ~Quest ();


   virtual void loadParams(const TiXmlElement* root = NULL);
   
   inline void setQuestName(const std::string& questName)                { this->questName = questName; }
   inline const std::string& getQuestName()                              { return this->questName; }
   inline void setQuestDescription(const std::string& questDescription)  { this->questDescription = questDescription; }
   inline const std::string& getQuestDescription()                       { return this->questDescription; }
   inline void setQuestPicture(const std::string& questPicture)          { this->questPicture = questPicture; }
   inline const std::string& getQuestPicture()                           { return this->questPicture; }
   inline void setQuestDifficulty(const std::string& questDifficulty)    { this->questDifficulty = questDifficulty; }
   inline const std::string& getQuestDifficulty()                        { return this->questDifficulty; }
   
   inline void setQuestPersons(const std::string& questPersons)          { this->questPersons = questPersons; }
   inline const std::string& getQuestPersons()                        { return this->questPersons; }
   
   inline void setRewardDescription(const std::string& rewardDescription){ this->rewardDescription  = rewardDescription; }
   inline const std::string& getRewardDescription()                      { return this->rewardDescription; }
   inline void setRewardPicture(const std::string& rewardPicture)        { this->rewardPicture  = rewardPicture; }
   inline const std::string& getRewardPicture()                          { return this->rewardPicture; }
   void setQuestActive();
   void setQuestInactive();
   const bool getQuestStatus();
   

   
  private:
    bool                    Status;
    std::string             questName;
    std::string             questDescription;
    std::string             questPersons;
    std::string             questPicture;
    std::string             questDifficulty;
    std::string             rewardDescription;
    std::string             rewardPicture;

};

#endif /* _QUEST_H */
