

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Andreas Hejj

*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "debug.h"
#include "quest.h"

#include "event_handler.h"

#include "state.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"

#include "graphics_engine.h"
#include "camera.h"
#include "sound_engine.h"

#include "sound_source.h"

#include "glgui.h"
#include "menu/glgui_imagebutton.h"
#include "glgui_multiline_text.h"
#include <glgui_image.h>


#include "shell_command.h"




ObjectListDefinition(Quest);

Quest::Quest(const TiXmlElement* root)
{
  this->registerObject(this, Quest::_objectList);
  
  this->Status = false;

  if( root != NULL)
    this->loadParams(root);

}


/**
 * deconstructor
 */
Quest::~Quest () 
{
}




/**
 * loads the xml tagsthis->questDescription
 * @param root: root xml tag for this element
 */
 
void Quest::loadParams(const TiXmlElement* root)
{
   LoadParam(root, "quest-name", this, Quest, setQuestName)
       .describe("sets the name of a quest");
   LoadParam(root, "quest-description", this, Quest, setQuestDescription)
       .describe("sets the description of a quest");
   LoadParam(root, "quest-picture", this, Quest, setQuestPicture)
       .describe("sets the picture of a quest");
   LoadParam(root, "quest-difficulty", this, Quest, setQuestDifficulty)
       .describe("sets the difficulty of a quest");
   LoadParam(root, "quest-persons", this, Quest, setQuestPersons)
       .describe("sets the number of persons needed for a quest");
   LoadParam(root, "reward-description", this, Quest, setRewardDescription)
       .describe("sets the description of a reward");
   LoadParam(root, "reward-picture", this, Quest, setRewardPicture)
       .describe("sets the Picture of a reward");
   
}

void Quest::setQuestActive()
{
  this->Status = true;
}

void Quest::setQuestInactive()
{
  this->Status = false;
}

const bool Quest::getQuestStatus()
{
  return this->Status;
}
