/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Marc Schaerrer
   co-programmer:
*/
//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "swarm_launcher.h"

#include "weapon_manager.h"
#include "world_entities/projectiles/projectile.h"
#include "world_entities/projectiles/swarm_projectile.h"

#include "model.h"

#include "state.h"
#include "animation3d.h"

#include <list>
#include <iterator>
#include "util/state.h"

#include "math/quaternion.h"

#include "util/loading/factory.h"



using namespace std;

ObjectListDefinition(SwarmLauncher);
CREATE_FACTORY(SwarmLauncher);

/**
 *  standard constructor
 *
 * creates a new SwarmLauncher
 */
SwarmLauncher::SwarmLauncher()
  : Weapon()
{
  this->init();
}

/**
 * creates a new SwarmLauncher from a TiXmlElement
 */
SwarmLauncher::SwarmLauncher(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}

/**
 *  standard deconstructor
*/
SwarmLauncher::~SwarmLauncher ()
{
  // model will be deleted from WorldEntity-destructor
}

void SwarmLauncher::init()
{
  this->registerObject(this, SwarmLauncher::_objectList);

  Animation3D* animation1 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation2 = this->getAnimation(WS_DEACTIVATING, this);

  animation1->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);

  animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);

  this->setStateDuration(WS_SHOOTING, .6);
  this->setStateDuration(WS_RELOADING, 1.0f);
  this->setStateDuration(WS_ACTIVATING, .4);
  this->setStateDuration(WS_DEACTIVATING, .4);

  this->setEnergyMax(10);
  this->increaseEnergy(10);
  //this->minCharge = 2;

  this->setCapability(WTYPE_ALLDIRS | WTYPE_TURRET | WTYPE_DIRECTIONAL | WTYPE_LIGHT);
  this->setProjectileTypeC("SwarmProjectile");

  this->loadModel("models/guns/turret1.obj", 1.0);

  this->setEmissionPoint(1.684, 0.472, 0);
  this->getProjectileFactory()->prepare(50);

  this->setActionSound(WA_SHOOT, "sound/explosions/explosion_1.wav");
  this->setActionSound(WA_ACTIVATE, "sound/vocals/missiles.wav");
  this->setActionSound(WA_RELOAD, "sound/vocals/reload.wav");

}

void SwarmLauncher::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void SwarmLauncher::activate()
{
}

void SwarmLauncher::deactivate()
{
}

void SwarmLauncher::tick(float dt)
{
  if (!Weapon::tickW(dt))
    return;

  Quaternion quat;
  Vector direction;
  if (this->getDefaultTarget() == NULL)
    direction = this->getAbsCoor();
  else
    direction = this->getDefaultTarget()->getAbsCoor() - this->getAbsCoor();

  direction.normalize();

  if (likely (this->getParent() != NULL))
    quat = Quaternion(direction, this->getParent()->getAbsDir().apply(Vector(0,1,0))) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;
  else
    quat = Quaternion(direction, Vector(0,1,0)) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;

  this->setAbsDirSoft(quat, 5);
}

void SwarmLauncher::fire()
{
  bool fired  = false;

  Projectile* pj = NULL;
  for( ObjectList<Playable>::const_iterator eIterator = Playable::objectList().begin(); eIterator !=Playable::objectList().end(); eIterator++)
  {
    if( ((*eIterator)->getOMListNumber() != (this->getOMListNumber() -1)) && ((*eIterator)->getClassCName() != "Weapon") && ((*eIterator)->getClassCName() != "Projectile") && ((*eIterator)->getAbsCoor() - this->getAbsCoor()).len() <= 300)
    {
      pj  = this->getProjectile();
      if (pj == NULL)
        return;

      fired = true;
      pj->setVelocity(this->getVelocity()+(this->getAbsDir().apply(Vector(1,0,0))*115.0 + VECTOR_RAND(10)));

      pj->setParent(PNode::getNullParent());
      pj->setAbsCoor(this->getEmissionPoint());
      pj->setAbsDir(this->getAbsDir());
      dynamic_cast<SwarmProjectile*>(pj)->setTarget( (PNode*)(*eIterator) );
      //pj->toList(OM_GROUP_01_PROJ);
      pj->activate();
    }
  }
  if( !fired)
    this->increaseEnergy( this->getProjectile()->getMinEnergy());
}
