/*!
 * @file spike_launcher.h
*/


#ifndef _SPIKE_LAUNCHER_H
#define _SPIKE_LAUNCHER_H

#include "weapon.h"

#define SPIKE_LAUNCHER_MAXRANGE = 500.0;

class SpikeLauncher : public Weapon
  {
  ObjectListDeclaration(SpikeLauncher);
  public:
    SpikeLauncher ();
    SpikeLauncher(const TiXmlElement* root);
    virtual ~SpikeLauncher ();

    void init();
    virtual void loadParams(const TiXmlElement* root);

    virtual void activate();
    virtual void deactivate();

    virtual void tick(float dt);
    virtual void fire();

    virtual void updateFireDir(Vector t, float angle);

  private:

  int           spikes;
  Vector*       launcher;
  float         size;
  };

#endif /* _SPIKE_LAUNCHER_H */
