/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Marc Schaerrer
   co-programmer:
*/
//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "spike_launcher.h"

#include "weapon_manager.h"
#include "world_entities/projectiles/projectile.h"
#include "world_entities/projectiles/spike_ball.h"

#include "model.h"

#include "state.h"
#include "animation3d.h"

#include <list>
#include <iterator>
#include "util/state.h"

#include "math/quaternion.h"

#include "util/loading/factory.h"



using namespace std;

ObjectListDefinition(SpikeLauncher);
CREATE_FACTORY(SpikeLauncher);

/**
 *  standard constructor
 *
 * creates a new SpikeLauncher
 */
SpikeLauncher::SpikeLauncher()
  : Weapon()
{
  this->init();
}

/**
 * creates a new SpikeLauncher from a TiXmlElement
 */
SpikeLauncher::SpikeLauncher(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}

/**
 *  standard deconstructor
*/
SpikeLauncher::~SpikeLauncher ()
{
  delete this->launcher;

  // model will be deleted from WorldEntity-destructor
}

void SpikeLauncher::init()
{
  this->registerObject(this, SpikeLauncher::_objectList);

  Animation3D* animation1 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation2 = this->getAnimation(WS_DEACTIVATING, this);

  animation1->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);

  animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);

  this->setStateDuration(WS_SHOOTING, .6);
  this->setStateDuration(WS_RELOADING, 1.0f);
  this->setStateDuration(WS_ACTIVATING, .4);
  this->setStateDuration(WS_DEACTIVATING, .4);

  this->setEnergyMax(10);
  this->increaseEnergy(10);
  //this->minCharge = 2;

  this->setCapability(WTYPE_ALLDIRS | WTYPE_TURRET | WTYPE_DIRECTIONAL | WTYPE_LIGHT);
  this->setProjectileTypeC("Spike");

//   this->loadModel("models/guns/turret1.obj", 1.0);
  this->size = 2.5;

  this->setEmissionPoint(0.0, 0.0, 0.0);


  this->spikes = 26;
  this->launcher = new Vector [this->spikes];

  this->getProjectileFactory()->prepare(this->spikes);  //we don't need more...

//   this->setActionSound(WA_SHOOT, "sound/explosions/explosion_1.wav");
//   this->setActionSound(WA_ACTIVATE, "sound/vocals/missiles.wav");
//   this->setActionSound(WA_RELOAD, "sound/vocals/reload.wav");

}

void SpikeLauncher::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void SpikeLauncher::activate()
{
  this->launcher[0] = Vector(1.0, 0.0, 0.0);
  this->launcher[1] = Vector(0.0, 1.0, 0.0);
  this->launcher[2] = Vector(0.0, 0.0, 1.0);

  this->launcher[3] = Vector(1.0, 1.0, 0.0);
  this->launcher[4] = Vector(0.0, 1.0, 1.0);
  this->launcher[5] = Vector(1.0, 0.0, 1.0);
  this->launcher[6] = Vector(1.0, -1.0, 0.0);
  this->launcher[7] = Vector(0.0, 1.0, -1.0);
  this->launcher[8] = Vector(-1.0, 0.0, 1.0);

  this->launcher[9] = Vector(-1.0, 1.0, 1.0);
  this->launcher[10] = Vector(1.0, 1.0, 1.0);
  this->launcher[11] = Vector(1.0, -1.0, 1.0);
  this->launcher[12] = Vector(-1.0, -1.0, 1.0);

  int tmp = this->spikes / 2;
  for (int i = 0; i < tmp; i++)
  {
    this->launcher[i].normalize();
    this->launcher[tmp + i] =  this->launcher[i] * (-1);
  }
}

void SpikeLauncher::deactivate()
{
}

void SpikeLauncher::tick(float dt)
{
  if (!Weapon::tickW(dt))
    return;

  Quaternion quat;
  Vector direction;
  if (this->getDefaultTarget() == NULL)
    direction = this->getAbsCoor();
  else
    direction = this->getDefaultTarget()->getAbsCoor() - this->getAbsCoor();

  direction.normalize();

  if (likely (this->getParent() != NULL))
    quat = Quaternion(direction, this->getParent()->getAbsDir().apply(Vector(0,1,0))) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;
  else
    quat = Quaternion(direction, Vector(0,1,0)) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;

  this->setAbsDirSoft(quat, 5);
}

void SpikeLauncher::updateFireDir(Vector v, float angle){

  float** m = new float* [3];
  for( int i = 0; i < 3 ; i++)
    m[i] = new float;

  float nx, ny, nz, ca, sa;

  nx = v.x;
  ny = v.y;
  nz = v.z;

  ca = cos (angle);
  sa = sin (angle);
// final version below... easier to to cheat with the one above.
/*
  nx = this->getParent()->getRotationVector().x;
  ny = this->getParent()->getRotationVector().y;
  nz = this->getParent()->getRotationVector().z;

  ca = cos (this->getParent()->getAngle());
  sa = sin (this->getParent()->getAngle());*/
/*
  float * m = new float [9];
  m[0] = 1.0f+(1.0f-ca)*(nx*nx-1.0f);
  m[1] = -nz*sa+(1.0f-ca)*nx*ny;
  m[2] = ny*sa+(1.0f-ca)*nx*nz;
  m[3] = nz*sa+(1.0f-ca)*nx*ny;
  m[4] = 1.0f+(1.0f-ca)*(ny*ny-1.0f);
  m[5] = -nx*sa+(1.0f-ca)*ny*nz;
  m[6] = -ny*sa+(1.0f-ca)*nx*nz;
  m[7] = nx*sa+(1.0f-ca)*ny*nz;
  m[8] = 1.0f+(1.0f-ca)*(nz*nz-1.0f);*/

  m[0][0] = nx * nx * (1 - ca) + ca;
  m[0][1] = nx * ny * (1 - ca) + nz * sa;
  m[0][2] = nx * nz * (1 - ca) - ny * sa;
  m[1][0] = nx * nz * (1 - ca) - nz * sa;
  m[1][1] = ny * ny * (1 - ca) + ca;
  m[1][2] = ny * nz * (1 - ca) + nx * sa;
  m[2][0] = nx * nz * (1 - ca) + ny * sa;
  m[2][1] = ny * nz * (1 - ca) - nx * sa;
  m[2][2] = nz * nz * (1 - ca) + ca;

  float x, y, z;
  for (int i = 0; i < this->spikes;i++){
    printf("%i ", i);
    x = m[0][0] * this->launcher[i].x + m[0][1] * this->launcher[i].y + m[0][2] * this->launcher[i].z;
    y = m[1][0] * this->launcher[i].x + m[1][1] * this->launcher[i].y + m[1][2] * this->launcher[i].z;
    z = m[2][0] * this->launcher[i].x + m[2][1] * this->launcher[i].y + m[2][2] * this->launcher[i].z;
/*
    x = this->launcher[i].x * m[0] + this->launcher[i].y * m[1] + this->launcher[i].z * m[2];
    y = this->launcher[i].x * m[3] + this->launcher[i].y * m[4] + this->launcher[i].z * m[5];
    z = this->launcher[i].x * m[6] + this->launcher[i].y * m[7] + this->launcher[i].z * m[8];*/
    this->launcher[i] = Vector (x, y, z);
  }
  printf("\n");

  for( int i = 0; i < 3 ; i++)
    delete m[i];
  delete m;
}


void SpikeLauncher::fire()
{
  updateFireDir(VECTOR_RAND(1), 20);

  Projectile* pj = NULL;
  for (int i = 0; i < this->spikes; i++)
  {
    pj  = this->getProjectile();
    if (pj == NULL) // if true, we do have a problem!!
      return;

    pj->setVelocity(this->launcher[i].getNormalized() * 300.0);

    pj->setParent(PNode::getNullParent());
    pj->setAbsCoor(this->getAbsCoor() + this->launcher[i] * this->size);
    Quaternion q;
    pj->setRelDir(q.lookAt(Vector(), this->launcher[i], VECTOR_RAND(1)));

    pj->activate();
  }
}
