#ifndef HEAVY_BLASTER_H
#define HEAVY_BLASTER_H


#include "weapon.h"

#define    W_LEFT        0
#define    W_RIGHT       1

/**
 *	@author Marc Schaerer <marcscha@ee.ethz.ch>
 *  
 *  Heavy Blaster class
 */
class HeavyBlaster : public Weapon
{
  //ObjectListDeclaration(HeavyBlaster);
  public:
    HeavyBlaster(int leftRight);
    HeavyBlaster (const TiXmlElement* root);
    virtual ~HeavyBlaster();

    void init(int leftRight);
    virtual void loadParams(const TiXmlElement* root);

    virtual void activate();
    virtual void deactivate();

    virtual void fire();

    virtual void draw() const;

  private:
    PNode*** objComp;
    Animation3D*** shootAnim;
    PNode** emissionPoint;

    int activeBarrel;

    int leftRight;
};

#endif
