

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer:
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "executor/executor.h"
#include "util/loading/factory.h"
#include "util/loading/load_param.h"


#include "test_entity2.h"
#include "debug.h"

#include "state.h"
#include "player.h"
#include "playable.h"
#include "material.h"


#include "state.h"




ObjectListDefinition(TestEntity2);
CREATE_FACTORY(TestEntity2);



/**
 *
 */
TestEntity2::TestEntity2()
{
  this->init();
}


/**
 *
 */
TestEntity2::TestEntity2(const TiXmlElement* root)
{
  this->init();

  if( root != NULL)
    this->loadParams(root);
}


/**
 *
 */
TestEntity2::~TestEntity2 ()
{}


/**
 *
 */
void TestEntity2::init()
{
  this->registerObject(this, TestEntity2::_objectList);
  this->toList(OM_GROUP_00);

  this->material = new Material();
  this->material->setIllum(3);
  this->material->setDiffuse(1.0,1.0,1.0);
  this->material->setSpecular(0.0,0.0,0.0);
  this->material->setAmbient(1.0, 1.0, 1.0);

  this->angle = 0;
  this->rotationSpeed = 3;

  this->material->setDiffuseMap("maps/TE2.tga");

}


/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void TestEntity2::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);
}


void TestEntity2::updateAngle()
{
  this->angle = this->angle + this->rotationSpeed;
}

void TestEntity2::draw() const
{

  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_LIGHTING);

  glPushMatrix();
  glMatrixMode(GL_MODELVIEW);


    /* translate */
  glTranslatef (this->getAbsCoor ().x,
                  this->getAbsCoor ().y,
                  this->getAbsCoor ().z);
  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
  glRotatef(this->angle, 1.0, 1.0, 1.0);
//PRINTF(0)("axis: %f\n", axis);


  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glShadeModel(GL_FLAT);
  glClearColor(0.0, 0.0, 0.0, 0.0);

  glEnable(GL_TEXTURE_2D);
  this->material->select();

  glColor3f(1.0, 1.0, 1.0);

  glBegin(GL_QUADS); // +X
    glTexCoord2f (0.0, 0.0);
    glVertex3f( 0.0f, -0.5f, -0.5f);
//     glNormal3f(1.0, 0.0, 0.0);

    glTexCoord2f (1.0, 0.0);
    glVertex3f( 0.0f, -0.5f , 0.5f);
//     glNormal3f(1.0, 0.0, 0.0);

    glTexCoord2f (1.0, 1.0);
    glVertex3f( 0.0, 0.5f , 0.5f );
//     glNormal3f(1.0, 0.0, 0.0);


    glTexCoord2f (0.0, 1.0);
    glVertex3f( 0.0, 0.5f, -0.5f );
//     glNormal3f(1.0, 0.0, 0.0);
  glEnd();

  glBegin(GL_QUADS); // +Y
    glTexCoord2f (0.0, 0.0);
    glVertex3f(-0.5f, 0.0f, -0.5f);
//     glNormal3f(0.0, 1.0, 0.0);

    glTexCoord2f (1.0, 0.0);
    glVertex3f(-0.5f, 0.0f , 0.5f);
//     glNormal3f(0.0, 1.0, 0.0);

    glTexCoord2f (1.0, 1.0);
    glVertex3f( 0.5f, 0.0f , 0.5f );
//     glNormal3f(0.0, 1.0, 0.0);

    glTexCoord2f (0.0, 1.0);
    glVertex3f( 0.5f, 0.0f, -0.5f );
//     glNormal3f(0.0, 1.0, 0.0);
  glEnd();

  glBegin(GL_QUADS);// +Z
    glTexCoord2f (0.0, 0.0);
    glVertex3f(-0.5f, -0.5f, 0.0f);
//     glNormal3f(0.0, 0.0, 1.0);

    glTexCoord2f (1.0, 0.0);
    glVertex3f(-0.5f, 0.5f , 0.0f);
//     glNormal3f(0.0, 0.0, 1.0);

    glTexCoord2f (1.0, 1.0);
    glVertex3f( 0.5f, 0.5f , 0.0f );
//     glNormal3f(0.0, 0.0, 1.0);

    glTexCoord2f (0.0, 1.0);
    glVertex3f( 0.5f, -0.5f, 0.0f );
//     glNormal3f(0.0, 0.0, 1.0);
  glEnd();

/*
  glBegin(GL_QUADS);// -X
    glTexCoord2f (0.0, 0.0);
    glVertex3f( 0.0f, -0.5f, -0.5f);
//     glNormal3f(-1.0, 0.0, 0.0);

    glTexCoord2f (1.0, 0.0);
    glVertex3f( 0.0f, 0.5f , -0.5f);
//     glNormal3f(-1.0, 0.0, 0.0);

    glTexCoord2f (1.0, 1.0);
    glVertex3f( 0.0, 0.5f , 0.5f );
//     glNormal3f(-1.0, 0.0, 0.0);

    glTexCoord2f (0.0, 1.0);
    glVertex3f( 0.0, -0.5f, 0.5f );
//     glNormal3f(-1.0, 0.0, 0.0);
  glEnd();

  glBegin(GL_QUADS);// -Y
    glTexCoord2f (0.0, 0.0);
    glVertex3f(-0.5f, 0.0f, -0.5f);
//     glNormal3f(0.0, -1.0, 0.0);

    glTexCoord2f (1.0, 0.0);
    glVertex3f(0.5f, 0.0f , -0.5f);
//     glNormal3f(0.0, -1.0, 0.0);

    glTexCoord2f (1.0, 1.0);
    glVertex3f( 0.5f, 0.0f , 0.5f );
//     glNormal3f(0.0, -1.0, 0.0);

    glTexCoord2f (0.0, 1.0);
    glVertex3f( -0.5f, 0.0f, 0.5f );
//     glNormal3f(0.0, -1.0, 0.0);
  glEnd();

  glBegin(GL_QUADS);// -Z
    glTexCoord2f (0.0, 0.0);
    glVertex3f(-0.5f, -0.5f, 0.0f);
//     glNormal3f(0.0, 0.0, -1.0);

    glTexCoord2f (1.0, 0.0);
    glVertex3f(0.5f, -0.5f , 0.0f);
//     glNormal3f(0.0, 0.0, -1.0);

    glTexCoord2f (1.0, 1.0);
    glVertex3f( 0.5f, 0.5f , 0.0f );
//     glNormal3f(0.0, 0.0, -1.0);

    glTexCoord2f (0.0, 1.0);
    glVertex3f( -0.5f, 0.5f, 0.0f );
//     glNormal3f(0.0, 0.0, -1.0);
  glEnd();*/

  glPopMatrix();
  glPopAttrib();
}

/**
 *
 */
void TestEntity2::tick (float time)
{
  Player* p = State::getPlayer();
  Playable* pl = p->getPlayable();

  this->setParent(pl);

  this->updateAngle();
}






