

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "projectile.h"

#include "world_entity.h"
#include "world_entities/weapons/weapon.h"
#include "model.h"
#include "sound/resource_sound_buffer.h"
#include "playable.h"

#include <cmath>

#include "debug.h"

ObjectListDefinition(Projectile);

/**
 *  standard constructor
*/
Projectile::Projectile () : WorldEntity()
{
  this->registerObject(this, Projectile::_objectList);

  this->lifeCycle = 0.0;
  this->lifeSpan = 1.0f; /* sec */
  this->target = NULL;
  this->removeNode();

  /* character attributes */
  this->setHealth(1.0f);
  this->setDamage(1.0f); // default damage of a projectile set to 100.0 damage points
  this->subscribeReaction( CoRe::CREngine::CR_PHYSICS_FULL_WALK, Playable::staticClassID());

  this->physDamage = 0.0f;
  this->elecDamage = 0.0f;
  //this->addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT);
}


/**
 *  standard deconstructor
*/
Projectile::~Projectile ()
{
  /*
     do not delete the test projectModel, since it is pnode
     and will be cleaned out by world
  */
  //delete this->projectileModel;
}

Projectile::Projectile (float pDamage, float eDamage, PNode* target) : WorldEntity()
{
  this->registerObject(this, Projectile::_objectList);

  this->lifeCycle = 0.0;
  this->lifeSpan = 1.0f; /* sec */
  this->removeNode();

  /* character attributes */
  this->setHealth(1.0f);
  this->setDamage(1.0f); // default damage of a projectile set to 100.0 damage points

  this->physDamage = pDamage;
  this->elecDamage = eDamage;
  this->target = target;

  //this->addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT);
}

void Projectile::initialize(float pDamage, float eDamage, PNode* target)
{
  /* character attributes*/
  this->physDamage = pDamage;
  this->elecDamage = eDamage;
  this->target = target;
}


void Projectile::loadExplosionSound(const std::string& explosionSound)
{
  if (!explosionSound.empty())
    this->explosionBuffer = OrxSound::ResourceSoundBuffer(explosionSound);
  else
    this->explosionBuffer = OrxSound::SoundBuffer();
}


void Projectile::loadEngineSound(const std::string& engineSound)
{
  if (!engineSound.empty())
    this->engineBuffer = OrxSound::ResourceSoundBuffer(engineSound);
  else
    this->engineBuffer = OrxSound::SoundBuffer();
}


void Projectile::setMinEnergy(float energyMin)
{
  this->energyMin = energyMin;
}


/**
 *  this sets the flight direction of the projectile
 * @param directin in which to flight

   this function will calculate a vector out of this to be used in the
   tick function
*/
void Projectile::setFlightDirection(const Quaternion& flightDirection)
{
  Vector v(1, 0, 0);
  this->flightDirection = flightDirection.apply(v);
  this->flightDirection.normalize();
}

/**
 *  sets the velocity vector to a spec speed
 * @param velocity: vector of the velocity
*/
void Projectile::setVelocity(const Vector &velocity)
{
  //Vector offsetVel =
  this->velocity = velocity;
  // offsetVel.normalize();
  //this->velocity += (offsetVel * 50.0);
}



void Projectile::setTarget(PNode* target)
{
  if (this->target == NULL)
    this->target = new PNode(target, PNODE_REPARENT_ON_PARENTS_REMOVE | PNODE_REPARENT_TO_NULL | PNODE_PROHIBIT_DELETE_WITH_PARENT);
  else
    this->target->setParent(target);
}


void Projectile::collidesWith (WorldEntity* target, const Vector& location)
{
  dynamic_cast<SpaceShip*>(target)->damage(this->getPhysDamage(),this->getElecDamage());
//   this->destroy(NULL);
  this->destroy(target);
}



/**
 * signal tick, time dependent things will be handled here
 * @param dt since last tick
*/
void Projectile::tick (float dt)
{
  if (this->tickLifeCycle(dt))
    this->destroy( NULL );
}


/**
 *  the function gets called, when the projectile is destroyed
*/
void Projectile::destroy (WorldEntity* killer)
{
  if (this->explosionBuffer.loaded())
    this->soundSource.play(this->explosionBuffer);
}

