/*!
 * @file mbolt.h
 * @brief medium blaster bolt
*/

#ifndef _MBOLT_H
#define _MBOLT_H

#include "projectile.h"
#include "material.h"

class Vector;
class Weapon;
class SpriteParticles;
class ParticleEmitter;
class FastFactory;
class Trail;

class MBolt : public Projectile
{
  ObjectListDeclaration(MBolt);
  public:
    MBolt ();
    virtual ~MBolt ();


    virtual void activate();
    virtual void deactivate();

    virtual void hit (float damage, WorldEntity* entity);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float dt);
    virtual void draw () const;

  private:
    static FastFactory*               fastFactory;
    static SpriteParticles*           explosionParticles;

    Trail*                            trail;

    float                             angle;
    static const float                rotationSpeed = 1080;

    ParticleEmitter*                  emitter;

    Material*                         mat;


    WorldEntity* hitEntity; // FIXME TEMPORARY
};

#endif /* _MBOLT_H */
