/*!
 * @file lbolt.h
 * @brief light blaster lbolt
*/

#ifndef _LBOLT_H
#define _LBOLT_H

#include "projectile.h"
#include "effects/billboard.h"

class Vector;
class Weapon;
class SpriteParticles;
class ParticleEmitter;
class FastFactory;

class LBolt : public Projectile
{
  ObjectListDeclaration(LBolt);
  public:
    LBolt ();
    virtual ~LBolt ();


    virtual void activate();
    virtual void deactivate();

    virtual void hit (float damage, WorldEntity* entity);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float dt);
    virtual void draw () const;


  private:
    static FastFactory*               fastFactory;

    static SpriteParticles*           explosionParticles;

    ParticleEmitter*                  emitter;

    float                             angle;
    float                             rotationSpeed;

    Billboard*                        halo;

    WorldEntity* hitEntity; // FIXME TEMPORARY
};

#endif /* _LBOLT_H */
