 /*!
 * @file player.h
 * Implements a basic playable WorldEntity
 */

#ifndef _PLAYER_H
#define _PLAYER_H

#include "event_listener.h"

#include "util/hud.h"

/* Forward Declaration */
class Playable;


//! Basic playable WorldEntity
/**
  *  this is the debug player - actualy we would have to make a new
     class derivated from Player for each player. for now, we just use
     the player.cc for debug also
*/
class Player : public EventListener
{
  ObjectListDeclaration(Player);

  public:
    Player();
    virtual ~Player();

    bool              setPlayable(Playable* controllalble);
    bool              eject();
    inline Playable*  getPlayable() const  { return this->playable; };


     inline Hud& hud() { return this->_hud; };
     inline const Hud& hud() const { return this->_hud; };


    void              weaponConfigChanged();
    void              enterNewPlayable();

    // eventListener extension.
    virtual void      process(const Event &event);

  private:
    Playable*         playable;                 //!< The one we controll or NULL if none
    Hud               _hud;                     //!< The HUD to be displayed for this Player.
};

#endif /* _PLAYER_H */
