/*!
 * @file emitter_node.h
  *  Definition of a EmitterNode
  *  An emitter node is a node that takes an emitter and a particle system and keeps them alive for a given amount of time.
*/

#ifndef _EMITTER_NODE_H
#define _EMITTER_NODE_H

#include "world_entity.h"
#include "dot_emitter.h"
#include "particle_system.h"

// FORWARD DECLARATION
class DotEmitter;
class ParticleEmitter;
class TiXmlElement;

//! A class to handle an Emitter.
class EmitterNode : public WorldEntity
{
  ObjectListDeclaration(EmitterNode);
public:
  EmitterNode(float lifetime);
  virtual ~EmitterNode();

  virtual void loadParams(const TiXmlElement* root = NULL);
  
  virtual void tick( float time);

  bool start();
  inline void setVelocity(Vector velocity) { this->velocity = velocity;};

  inline void setupParticle(DotEmitter* emitter, ParticleSystem* system) { this->emitter = emitter; this->emitter->setParent( this); this->system = system;} ;
  void setLifetime( float lifeTime) { this->lifeSpan  = lifeTime;};

private:
  float           lifeSpan;           //!< Life time of this emitter node
  float           lifeCycle;          
  bool            started;            //!< was this emitter node started?

  Vector          velocity;           //!< Velocity per second of the node

  DotEmitter*  emitter;          //!< emitter which is held and kept alive
  ParticleSystem*   system;           //!< system to be used on the particle emitter
};

#endif /* _EMITTER_NODE_H */
