/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GRAPHICS

#include "emitter_node.h"

#include "particle_system.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"
#include "debug.h"

ObjectListDefinition(EmitterNode);
//CREATE_FAST_FACTORY(EmitterNode);

/**
 *  standard constructor
*/
EmitterNode::EmitterNode( float lifetime)
{
  this->registerObject(this, EmitterNode::_objectList);

  this->toList(OM_ENVIRON);

  this->system = NULL;
  this->emitter = NULL;
  this->lifeCycle = 0.0;
  this->lifeSpan = lifetime;

  this->setParent( PNode::getNullParent());
}

/**
 *  standard destructor

   removes the EmitterSystem from the ParticleEngine
*/
EmitterNode::~EmitterNode ()
{
  this->emitter->setSystem(NULL);
  this->removeNode();
}

/**
 *  loads a EmitterNode from a XML-element
 * @param root the XML-element to load from
*/
void EmitterNode::loadParams(const TiXmlElement* root)
{
  PNode::loadParams(root);

  LoadParam(root, "life-time", this, EmitterNode, setLifetime)
    .describe("Amount of time this emitter node shall remain");
}

bool EmitterNode::start()
{
  this->started  = true;

  this->emitter->start();
  this->emitter->setSystem( this->system);

  return this->started;
}

void EmitterNode::tick(float dt)
{

  if( !this->started)
    return;

  this->lifeCycle += dt/this->lifeSpan;

  if( this->lifeCycle >= 1.0f)
  {
//   this->removeNode();
 //   this->emitter->stop();
    this->emitter->setSystem(NULL);
    this->started = false;
    this->toList(OM_NULL);

//    this->destroy( NULL );
  }
  this->shiftCoor(this->velocity * dt);
}
