/*!
 * @file glgui_energywidgetvertical.h
 * @brief Definition of an EnergyWidgetVertical, that displays a bar and a Text
*/

#ifndef _GLGUI_ENERGY_WIDGET_VERTICAL_H
#define _GLGUI_ENERGY_WIDGET_VERTICAL_H

//#include "glgui_box.h"
#include "glgui_bar.h"
#include "glgui_text.h"
#include "glgui_image.h"

namespace OrxGui
{

  //! A class for ...
  class GLGuiEnergyWidgetVertical : public GLGuiWidget
  {

  public:
    GLGuiEnergyWidgetVertical();
    virtual ~GLGuiEnergyWidgetVertical();

    void setMaximum(float max);
    void setValue(float value);
    void setDisplayedImage(const std::string& imageName);

    inline GLGuiImage* getImageWidget() {return this->_image;};
    inline GLGuiText* getValueWidget() {return this->_valueText;};
    inline GLGuiBar* getBarWidget() {return this->_bar;};

  protected:
    virtual void resize();
    virtual void showing();
    virtual void hiding();

  private:
    GLGuiImage*              _image;
    GLGuiText*               _valueText;
    GLGuiBar*                _bar;

  };
}
#endif /* _GLGUI_ENERGY_WIDGET_VERTICAL_H */
