/*!
 * @file track.h
 */

#ifndef _TRACK_H_
#define _TRACK_H_

#include "curve.h"
#include "base_object.h"

// Forward Definition
class PNode;
class TiXmlElement;

class Track : public BaseObject
{
  ObjectListDeclaration(Track);

 public:
   Track();
   Track(const TiXmlElement* root);
   virtual ~Track();

   virtual void loadParams(const TiXmlElement* root);
   void addPoint(float x, float y, float z);
   void addPointV(Vector newPoint);
   void setSpeed(float speed);

   //void finalize();
   inline Vector calcPos() const;
   inline Vector calcDir() const;
   void tick(float dt);

   PNode* getTrackNode();
   
//   void drawGraph(float dt) const;
      
   //float                 startingTime;         //!< The time at which this Track begins.
   float                 duration;             //!< The time used to cross this Track (curve).
   float                 endTime;              //!< The time at which this Track ends.
   float                 width;                //!< Th width of the Path. This tells the Player(s), how far he(they) can go to the left/right.

   int                   nodeCount;            //!< The count of points this Track has.
   Curve*                curve;                //!< The Curve of this Track

 private:
   void init();


 private:
   CurveType            curveType;              //!< The CurveType the entire TrackSystem will have.
   float                localTime;              //!< The time that has been passed since the traveling the Track.
   PNode*               trackNode;              //!< The node that is slave to the Track. This node will be moved while update the Track, and must NOT move itself.
};

#endif /* _TRACK_H */
