/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Marc Schaerrer
   co-programmer:
*/
//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "spike_thrower.h"

#include "weapon_manager.h"
#include "world_entities/projectiles/projectile.h"
#include "world_entities/projectiles/spike_ball.h"
#include "world_entities/projectiles/spike.h"

#include "model.h"

#include "state.h"
#include "animation3d.h"

#include <list>
#include <iterator>
#include "util/state.h"

#include "math/quaternion.h"

#include "util/loading/factory.h"



using namespace std;

ObjectListDefinition(SpikeThrower);
CREATE_FACTORY(SpikeThrower);

/**
 *  standard constructor
 *
 * creates a new SpikeThrower
 */
SpikeThrower::SpikeThrower()
  : Weapon()
{
  this->init();
}

/**
 * creates a new SpikeThrower from a TiXmlElement
 */
SpikeThrower::SpikeThrower(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}

/**
 *  standard deconstructor
*/
SpikeThrower::~SpikeThrower ()
{

  // model will be deleted from WorldEntity-destructor
}

void SpikeThrower::init()
{
  this->registerObject(this, SpikeThrower::_objectList);
/*
  Animation3D* animation1 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation2 = this->getAnimation(WS_DEACTIVATING, this);

  animation1->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);

  animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);*/

  this->setStateDuration(WS_SHOOTING, .6);
  this->setStateDuration(WS_RELOADING, 1.0f);
  this->setStateDuration(WS_ACTIVATING, .4);
  this->setStateDuration(WS_DEACTIVATING, .4);

  this->setEnergyMax(10);
  this->increaseEnergy(10);
  //this->minCharge = 2;

  this->setCapability(WTYPE_ALLDIRS | WTYPE_TURRET | WTYPE_DIRECTIONAL | WTYPE_LIGHT);
  this->setProjectileTypeC("SpikeBall");

//   this->loadModel("models/guns/turret1.obj", 1.0);

  this->setEmissionPoint(2, 0, 0);
  this->getProjectileFactory()->prepare(50);

  this->setActionSound(WA_SHOOT, "sound/explosions/explosion_1.wav");
  this->setActionSound(WA_ACTIVATE, "sound/vocals/missiles.wav");
  this->setActionSound(WA_RELOAD, "sound/vocals/reload.wav");

}

void SpikeThrower::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void SpikeThrower::activate()
{
}

void SpikeThrower::deactivate()
{
}

void SpikeThrower::tick(float dt)
{
  if (!Weapon::tickW(dt))
    return;

  Quaternion quat;
  Vector direction;
  if (this->getDefaultTarget() == NULL)
    direction = this->getAbsCoor();
  else
    direction = this->getDefaultTarget()->getAbsCoor() - this->getAbsCoor();

  direction.normalize();

  if (likely (this->getParent() != NULL))
    quat = Quaternion(direction, this->getParent()->getAbsDir().apply(Vector(0,1,0))) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;
  else
    quat = Quaternion(direction, Vector(0,1,0)) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;

  this->setAbsDirSoft(quat, 5);
}

void SpikeThrower::fire()
{
  Projectile* pj =  this->getProjectile();
  if (pj == NULL)
    return;

  // set the owner
  pj->setOwner(this->getOwner());

  pj->setParent(PNode::getNullParent());

  dynamic_cast<SpikeBall*>(pj)->setVelocity(this->getAbsDir().apply(Vector(1,0,0))*110);

  pj->setAbsCoor(this->getEmissionPoint());
  pj->setAbsDir(this->getAbsDir());
  pj->activate();

//   this->increaseEnergy( - this->getProjectile()->getMinEnergy());

}
