#include "medium_blaster.h"
#include "world_entities/projectiles/projectile.h"

#include "world_entity.h"
#include "static_model.h"
#include "weapon_manager.h"
#include "util/loading/factory.h"

#include "animation3d.h"

#include "loading/fast_factory.h"

//
//ObjectListDefinition(MediumBlaster);
CREATE_FACTORY(MediumBlaster);
/**
 * Standard constructor
 */
MediumBlaster::MediumBlaster ()
 : Weapon()
{
    this->init();
}

MediumBlaster::MediumBlaster (const TiXmlElement* root = NULL)
 : Weapon()
{
    this->init();
    if (root != NULL)
      this->loadParams(root);
}

/**
 * Default destructor
 */
MediumBlaster::~MediumBlaster()
{
      // model will be deleted from WorldEntity-destructor
  for (int i = 0; i < this->getBarrels(); i++)
  {
   delete [] this->shootAnim[i];
  }
  delete [] this->shootAnim;
}

void MediumBlaster::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void MediumBlaster::init()
{
  this->loadModel("models/guns/blaster.obj", .33);

  this->setStateDuration(WS_SHOOTING, 0.2);   // 5 Schuss pro Sekunde

  this->setStateDuration(WS_RELOADING, 0);
  this->setStateDuration(WS_ACTIVATING, .5); //.5);
  this->setStateDuration(WS_DEACTIVATING, 1); // 1);

  this->setEnergyMax(500);
  this->increaseEnergy(500);
  //this->minCharge = 2;

  this->setActionSound(WA_SHOOT, "sound/laser.wav");
  this->setActionSound(WA_ACTIVATE, "sound/voices/lasers.wav");
  this->setActionSound(WA_RELOAD, "sound/spawn/alien_generator.wav");

  this->setCapability(WTYPE_ALLDIRS | WTYPE_DIRECTIONAL | WTYPE_LIGHT);
  this->setProjectileTypeC("MBolt");   // FIXME temp project type until the blaste class exist
  this->prepareProjectiles(100);


  this->setBarrels(1);
  this->setSegs(2);
  this->activeBarrel = 0;

  this->objComp = new PNode**[this->getBarrels()];
  this->shootAnim = new Animation3D**[this->getBarrels()];
  for (int i = 0; i < this->getBarrels(); i++)
  {
    this->objComp[i] = new PNode* [this->getSegs()];
    this->shootAnim[i] = new Animation3D* [this->getSegs()];
    for(int j = 0; j < this->getSegs(); j++)
    {
      this->objComp[i][j] = new PNode;
      this->shootAnim[i][j] = new Animation3D(this->objComp[i][j]);
      this->shootAnim[i][j]->setInfinity(ANIM_INF_CONSTANT);
    }
  }

  for (int i = 0; i < this->getBarrels(); i++){
    this->shootAnim[i][0]->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.04, ANIM_LINEAR, ANIM_NULL);
    this->shootAnim[i][0]->addKeyFrame(Vector(-0.333, 0.0, 0.0), Quaternion(), 0.15, ANIM_LINEAR, ANIM_NULL);
    this->shootAnim[i][0]->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.01, ANIM_LINEAR, ANIM_NULL);

    this->shootAnim[i][1]->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.04, ANIM_LINEAR, ANIM_NULL);
    this->shootAnim[i][1]->addKeyFrame(Vector(.166, 0.0, 0.0), Quaternion(), 0.15, ANIM_LINEAR, ANIM_NULL);
    this->shootAnim[i][1]->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.01, ANIM_LINEAR, ANIM_NULL);
  }

  Animation3D* animation2 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation3 = this->getAnimation(WS_DEACTIVATING, this);

  animation2->setInfinity(ANIM_INF_CONSTANT);
  animation3->setInfinity(ANIM_INF_CONSTANT);


  this->setEmissionPoint(1.3, 0, 0);

  animation2->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
  animation2->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);

  animation3->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);
  animation3->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
}


void MediumBlaster::fire()
{
  Projectile* pj =  this->getProjectile();
  if (pj == NULL)
    return;

  // set the owner
  pj->setOwner(this->getOwner());

  pj->setParent(PNode::getNullParent());

  pj->setVelocity(this->getParent()->getVelocity() + this->getAbsDir().apply(Vector(1,0,0))*160);

  pj->setAbsCoor(this->getEmissionPoint());
  pj->setAbsDir(this->getAbsDir());
  pj->activate();

  for (int i = 0; i < this->getSegs(); i++)
    this->shootAnim[this->activeBarrel][i]->replay();
}

/**
 *  this activates the weapon
*/
void MediumBlaster::activate()
{
}

/**
 *  this deactivates the weapon
*/
void MediumBlaster::deactivate()
{
}

void MediumBlaster::draw() const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);

  static_cast<StaticModel*>(this->getModel())->draw(2);

  glPushMatrix();
    glTranslatef (this->objComp[0][0]->getAbsCoor().x, this->objComp[0][0]->getAbsCoor().y, this->objComp[0][0]->getAbsCoor().z);
    static_cast<StaticModel*>(this->getModel())->draw(1);
  glPopMatrix();

  glPushMatrix();
    glTranslatef (this->objComp[0][1]->getAbsCoor().x, this->objComp[0][1]->getAbsCoor().y, this->objComp[0][1]->getAbsCoor().z);
    static_cast<StaticModel*>(this->getModel())->draw(0);
  glPopMatrix();

  glPopMatrix();
}
