#include "light_blaster.h"
#include "world_entities/projectiles/projectile.h"

#include "world_entity.h"
#include "static_model.h"
#include "weapon_manager.h"
#include "util/loading/factory.h"

#include "animation3d.h"

#include "loading/fast_factory.h"

CREATE_FACTORY(LightBlaster);
/**
 * Standard constructor
 */
LightBlaster::LightBlaster ()
 : Weapon()
{
    this->init();
}

LightBlaster::LightBlaster (const TiXmlElement* root = NULL)
 : Weapon()
{
    this->init();
    if (root != NULL)
      this->loadParams(root);
}

/**
 * Default destructor
 */
LightBlaster::~LightBlaster()
{

  for (int i = 0; i < this->getBarrels(); i++)
  {
   delete [] this->shootAnim[i];
   delete [] this->objComp[i];
  }
  delete [] this->emissionPoint;
   delete [] this->shootAnim;
   delete [] this->objComp;
/*
    for(int j = 0; j < this->getSegs(); j++)
    {
      delete this->shootAnim[i][j];
      delete this->objComp[i][j];
    }
    delete this->shootAnim[i];
    delete this->objComp[i];
    delete this->emissionPoint[i];
  }*/

//  this->deconstr();
      // model will be deleted from WorldEntity-destructor
}

void LightBlaster::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void LightBlaster::init()
{

  this->loadModel("models/guns/gattling.obj", 0.333);
  

  this->setStateDuration(WS_SHOOTING, 0.05);  // 20 Schuss pro Sekunde
  this->setStateDuration(WS_RELOADING, 0);
  this->setStateDuration(WS_ACTIVATING, .5);
  this->setStateDuration(WS_DEACTIVATING, 1);

  this->setEnergyMax(500);
  this->increaseEnergy(500);
  //this->minCharge = 2;

  this->setActionSound(WA_SHOOT, "sound/laser.wav");
  this->setActionSound(WA_ACTIVATE, "sound/voices/lasers.wav");
  this->setActionSound(WA_RELOAD, "sound/spawn/alien_generator.wav");

  this->setCapability(WTYPE_ALLDIRS | WTYPE_DIRECTIONAL | WTYPE_LIGHT);
  //this->setProjectileTypeC("RailProjectile");   // FIXME temp project type until the blaste class exist
  this->setProjectileTypeC("LBolt");   // Working; FIXME: add textures
//   this->setProjectileTypeC("Spike");   // Working; FIXME: add textures
  this->prepareProjectiles(100);

  this->setBarrels(3);
  this->setSegs(1);
  this->activeBarrel = 0;

  this->objComp = new PNode**[this->getBarrels()];
  this->emissionPoint = new PNode*[this->getBarrels()];
  this->shootAnim = new Animation3D**[this->getBarrels()];
  for (int i = 0; i < this->getBarrels(); i++)
  {
    this->objComp[i] = new PNode* [this->getSegs()];
    this->emissionPoint[i] = new PNode;
    this->emissionPoint[i]->setParent(this);             //< One EmissionPoint, that is a PNode connected to the weapon. You can set this to the exitting point of the Projectiles
    this->emissionPoint[i]->setName("EmissionPoint");
    this->emissionPoint[i]->addNodeFlags(PNODE_PROHIBIT_DELETE_WITH_PARENT);
    this->shootAnim[i] = new Animation3D* [this->getSegs()];
    for(int j = 0; j < this->getSegs(); j++)
    {
      this->objComp[i][j] = new PNode;
      this->shootAnim[i][j] = new Animation3D(this->objComp[i][j]);
      this->shootAnim[i][j]->setInfinity(ANIM_INF_CONSTANT);
    }
  }

  for (int i = 0; i < this->getBarrels(); i++ )
    this->emissionPoint[i]->setRelCoor(Vector(1.19, 0.0, 0.1));

//   Animation3D* animation1 = this->getAnimation(WS_SHOOTING, this);
  Animation3D* animation2 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation3 = this->getAnimation(WS_DEACTIVATING, this);

//   animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);
  animation3->setInfinity(ANIM_INF_CONSTANT);

//   this->setEmissionPoint(3.8, 1.2, 0);

  for (int i = 0; i < this->getBarrels(); i++){
    this->shootAnim[i][0]->addKeyFrame(Vector(), Quaternion(i * 120, Vector(1.0, 0.0, 0.0)), 0.049, ANIM_NULL, ANIM_LINEAR);
    this->shootAnim[i][0]->addKeyFrame(Vector(), Quaternion((i+1)*120, Vector(1.0, 0.0, 0.0)), 0.001, ANIM_NULL, ANIM_LINEAR);
  }


  animation2->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
  animation2->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);

  animation3->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.5, ANIM_LINEAR, ANIM_NULL);
  animation3->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
}


void LightBlaster::fire()
{
  Projectile* pj =  this->getProjectile();
  if (pj == NULL)
    return;

  // set the owner
  pj->setOwner(this->getOwner());

  pj->setParent(PNode::getNullParent());

//   pj->setVelocity(this->getAbsDir().apply(Vector(1,0,0))*250 + VECTOR_RAND(5));
  pj->setVelocity(this->getAbsDir().apply(Vector(1,0,0))*180);

  pj->setAbsCoor(this->emissionPoint[this->activeBarrel]->getAbsCoor());
  pj->setAbsDir(this->getAbsDir());
//   pj->toList(OM_GROUP_01_PROJ);
  pj->activate();

  for (int i = 0; i < this->getSegs(); i++)
    this->shootAnim[this->activeBarrel][i]->replay();

  // switch barrel
  this->activeBarrel = (this->activeBarrel + 1) % this->getBarrels();
}

/**
 *  this activates the weapon
*/
void LightBlaster::activate()
{
}

/**
 *  this deactivates the weapon
*/
void LightBlaster::deactivate()
{
}

void LightBlaster::draw() const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
    glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
    Vector tmpRot = this->getAbsDir().getSpacialAxis();
    glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
    static_cast<StaticModel*>(this->getModel())->draw();
  glPopMatrix();
}
