

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer:
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "executor/executor.h"
#include "util/loading/factory.h"
#include "util/loading/load_param.h"


#include "test_entity.h"
#include "debug.h"




#include "state.h"




ObjectListDefinition(TestEntity);
CREATE_FACTORY(TestEntity);



/**
 *
 */
TestEntity::TestEntity ()
{
  this->init();
}


/**
 *
 */
TestEntity::TestEntity(const TiXmlElement* root)
{
  this->init();

  if( root != NULL)
    this->loadParams(root);
}


/**
 *
 */
TestEntity::~TestEntity ()
{}


/**
 *
 */
void TestEntity::init()
{
  this->registerObject(this, TestEntity::_objectList);
  this->toList(OM_GROUP_00);
}


/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void TestEntity::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);
}

void TestEntity::draw() const
{
//   if(!mediaLoaded)
//     false;

  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_LIGHTING);
//   glDisable(GL_BLEND);
// 
//   glEnable(GL_TEXTURE_2D);
//   glBindTexture(GL_TEXTURE_2D, media_container->getFrameTexture(counter));

  glPushMatrix();
 /* glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);
  glRotatef(axis, 0.0f, 1.0f, 0.0f);*/
//PRINTF(0)("axis: %f\n", axis);

  glColor3f(1.0, 0, 0);

  glBegin(GL_QUADS);
    glVertex3f( 0.0f, -100.0f, 0.0f);
//     glTexCoord2f(1.0f, 1.0f);
    glVertex3f( 0.0f,  -100.0f , 2000.0f);
//     glTexCoord2f(0.0f, 1.0f);
    glVertex3f( 10000.0f,  -100.0f , 2000.0f );
//     glTexCoord2f(0.0f, 0.0f);
    glVertex3f( 10000.0f, -100.0f, 0.0f );
//     glTexCoord2f(1.0f, 0.0f);
    
  glEnd();

  glPopMatrix();
  glPopAttrib();
}

/**
 *
 */
void TestEntity::tick (float time)
{


}






