
/*!
 * @file spacecraft_2d.h
 * Implements the Control of a Spacecraft2D
 */

#ifndef _SPACECRAFT_2D_H
#define _SPACECRAFT_2D_H

#include "playable.h"

// Forward Declaration
class ParticleEmitter;
class ParticleSystem;

class Spacecraft2D : public Playable
{
  ObjectListDeclaration(Spacecraft2D);
  public:
    Spacecraft2D(const std::string& fileName);
    Spacecraft2D(const TiXmlElement* root = NULL);
    virtual ~Spacecraft2D();

    virtual void loadParams(const TiXmlElement* root);

    void setTravelSpeed(float travelSpeed);
    void setTravelHeight(float travelHeight);
    void setTravelDistance(const Vector2D& distance);
    void setTravelDistance(float x, float y);

    void setAirFriction(float friction) { this->airFriction = friction; };


    virtual void setPlayDirection(const Quaternion& rot, float speed = 0.0f);
    virtual void enter();
    virtual void leave();


    virtual void postSpawn();
    virtual void leftWorld();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);
    virtual void tick(float dt);
    virtual void draw() const;

    virtual void process(const Event &event);

  protected:
    virtual void enterPlaymode(Playable::Playmode playmode);

  private:
    void init();
    void movement(float dt);

  private:
    bool                  bForward;           //!< forward button pressed.
    bool                  bBackward;          //!< backward button pressed.
    bool                  bLeft;              //!< left button pressed.
    bool                  bRight;             //!< right button pressed.

    int                   yInvert;
    float                 mouseSensitivity;   //!< the mouse sensitivity

    /// Normal Movement.
    Quaternion            direction;          //!< the direction of the Spacecraft2D.
    float                 acceleration;       //!< the acceleration of the Spacecraft2D.
    float                 airFriction;        //!< AirFriction.
    float                 airViscosity;


    /// 2D-traveling
    PNode*                travelNode;
    float*                toTravelHeight;
    float                 travelSpeed;        //!< the current speed of the Hove (to make soft movement)

    Vector2D              travelDistance;     //!< Travel-Distance away from the TravelNode.

    /// Camera
    PNode                 cameraNode;
    float                 cameraLook;
    float                 rotation;


    ParticleEmitter*      burstEmitter;
    ParticleSystem*       burstSystem;
};

#endif /* _SPACECRAFT_2DS_H */
