/*!
 * @file swarm_projectile.h
 * @brief a SwarmProjectile Projectile
*/

#ifndef _SWARM_PROJECTILE_H
#define _SWARM_PROJECTILE_H

#include "projectile.h"

class Weapon;
class SpriteParticles;
class ParticleEmitter;
class FastFactory;
class Aim;
class Trail;

class SwarmProjectile : public Projectile
{
  ObjectListDeclaration(SwarmProjectile);
  public:
    SwarmProjectile ();
    virtual ~SwarmProjectile ();

    virtual void activate();
    virtual void deactivate();

    virtual void hit (WorldEntity* entity, float damage);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float time);
    virtual void draw () const;

    void setTarget(PNode* target);

  private:
    static FastFactory*               fastFactory;
    static SpriteParticles*           explosionParticles;

    Trail*                            trail;

    ParticleEmitter*                  emitter;
    float                             agility;
    float                             maxVelocity;
    float                             speed;
    Vector                            diffVector ;
    Vector                            correctionVector;

    Vector                            curDir;
    Vector                            lastDir;
    Vector                            oldPos;

    WorldEntity* hitEntity; // FIXME TEMPORARY

    Vector newDirection(Vector curDirection, Vector estTargetDir, float angle);

    // spinning missle
    float                             rotationSpeed;
    float                             angle;
};

#endif /* _SWARM_PROJECTILE_H */
