/*!
 * @file spike_ball.h
 * @brief Noxonian SpikeBall Projectile; 2 stage weapon, splits into spikes
*/

#ifndef _SPIKE_BALL_H
#define _SPIKE_BALL_H

#include "projectile_weapon.h"
#include "spike.h"
#include "effects/billboard.h"


#include "extendable.h"

class Vector;
class ProjectileWeapon;
class SpriteParticles;
class ParticleEmitter;
class FastFactory;


class SpikeBall : public ProjectileWeapon
{
  ObjectListDeclaration(SpikeBall);
  public:
    SpikeBall ();
    virtual ~SpikeBall ();


    virtual void activate();
    virtual void deactivate();

   // virtual void collidesWith(WorldEntity* entity, const Vector& location);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float dt);
    virtual void draw () const;

    inline void setVelocity(Vector velocity) { this->velocity = velocity; }


  private:
    static FastFactory*               fastFactory;

    static SpriteParticles*           explosionParticles;

    ParticleEmitter*                  emitter;

    Vector                            velocity;

    Billboard*                        halo;

    WorldEntity* hitEntity; // FIXME TEMPORARY

    void updateFireDir();
    virtual void blow();

    Vector*       launcher;
    float         size;

    bool          freeMode;

};

#endif /* _SPIKE_BALL_H */
