/*!
 * @file spike.h
 * @brief light blaster spike
*/

#ifndef _SPIKE_H
#define _SPIKE_H

#include "projectile.h"
#include "effects/billboard.h"

class Vector;
class Weapon;
class SpriteParticles;
class ParticleEmitter;
class FastFactory;

class Spike : public Projectile
{
  ObjectListDeclaration(Spike);
  public:
    Spike ();
    virtual ~Spike ();


    virtual void activate();
    virtual void deactivate();

   //virtual void collidesWith(WorldEntity* entity, const Vector& location);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float dt);
    virtual void draw () const;

    inline void setVelocity(Vector velocity) {this->velocity = velocity;}
  private:
    static FastFactory*               fastFactory;

    static SpriteParticles*           explosionParticles;

    ParticleEmitter*                  emitter;

    float                             angle;
    float                             rotationSpeed;

    WorldEntity* hitEntity; // FIXME TEMPORARY

    Vector                            velocity;
};

#endif /* _SPIKE_H */
