/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004-2006 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Nicolas Schlumberger, Marc Schaerrer
   co-programmer: Benjamin Grauer

*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "spike.h"

#include "state.h"
#include "model.h"

#include "particles/dot_emitter.h"
#include "particles/sprite_particles.h"

#include <cassert>
#include "debug.h"

#include "space_ships/space_ship.h"



ObjectListDefinition(Spike);
CREATE_FAST_FACTORY_STATIC(Spike);

/**
 *  standard constructor
*/
Spike::Spike () : Projectile()
{
  this->registerObject(this, Spike::_objectList);

  this->loadModel("models/projectiles/spike.obj", 2);

  this->setMinEnergy(1);
  this->setHealthMax(0);
  this->lifeSpan = 2.0;

  this->emitter = new DotEmitter(100, 5, M_2_PI);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
  this->emitter->setEmissionRate(300.0);
  this->emitter->setEmissionVelocity(50.0);

  this->angle = 0;
  this->rotationSpeed = 130;
}


/**
 *  standard deconstructor
*/
Spike::~Spike ()
{
  // delete this->emitter;

  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (Spike::explosionParticles != NULL && Spike::objectList().size() <= 1)
  {
    //if (ClassList::exists(Spike::explosionParticles, CL_PARTICLE_SYSTEM))
    //  delete Spike::explosionParticles;
    PRINTF(1)("Deleting Spike Particles\n");
/*
  if (Spike::objectList().exists(Spike::explosionParticles))
      delete Spike::explosionParticles; */
    Spike::explosionParticles = NULL;
  }

}

SpriteParticles* Spike::explosionParticles = NULL;

void Spike::activate()
{
  if (unlikely(Spike::explosionParticles == NULL))
  {
    Spike::explosionParticles = new SpriteParticles(1000);
    Spike::explosionParticles->setName("SpikeExplosionParticles");
    Spike::explosionParticles->setLifeSpan(.5, .3);
    Spike::explosionParticles->setRadius(0.0, 10.0);
    Spike::explosionParticles->setRadius(.5, 6.0);
    Spike::explosionParticles->setRadius(1.0, 3.0);
    Spike::explosionParticles->setColor(0.0, 1,1,0,.9);
    Spike::explosionParticles->setColor(0.5, .8,.8,0,.5);
    Spike::explosionParticles->setColor(1.0, .8,.8,.7,.0);
  }

  this->setDamage(5);
  this->setHealth(0);
}


void Spike::deactivate()
{
  assert (Spike::explosionParticles != NULL);
  //Spike::explosionParticles->removeEmitter(this->emitter);
  this->emitter->setSystem(NULL);
  this->lifeCycle = 0.0;

  this->toList(OM_NULL);
  this->removeNode();
  Spike::fastFactory->kill(this);
}

/*
void Spike::collidesWith(WorldEntity* entity, const Vector& location)
{
  PRINTF(0)("Collision with Spike\n");
  if (this->hitEntity != entity && entity->isA(CL_NPC))
    this->destroy( entity );
  this->hitEntity = entity;
  dynamic_cast<SpaceShip*>(entity)->damage(this->getDamage(),0);
//   this->deactivate();
}*/

/**
 *  signal tick, time dependent things will be handled here
 * @param dt time since last tick
*/
void Spike::tick (float dt)
{
  Vector v = this->velocity * dt;
  this->shiftCoor(v);

  if (this->tickLifeCycle(dt))
    this->deactivate();

  angle += rotationSpeed * dt;
}

/**
 *  the function gets called, when the projectile is destroyed
*/
void Spike::destroy (WorldEntity* killer)
{
  Projectile::destroy( killer );
  PRINTF(5)("DESTROY Spike\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.

  this->emitter->setSystem(Spike::explosionParticles);
}


void Spike::draw () const
{
  glPushAttrib(GL_ENABLE_BIT);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
  glRotatef(angle, 1.0, 0.0, 0.0);

  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  this->getModel()->draw();

  glPopMatrix();
  glPopAttrib();
}

