/*!
 * @file hhbolt.h
 * @brief heavy blaster hbolt
*/

#ifndef _HBOLT_H
#define _HBOLT_H

#include "projectile.h"
#include "effects/billboard.h"

class Vector;
class Weapon;
class SpriteParticles;
class ParticleEmitter;
class FastFactory;

class HBolt : public Projectile
{
  ObjectListDeclaration(HBolt);
  public:
    HBolt ();
    virtual ~HBolt ();


    virtual void activate();
    virtual void deactivate();

    virtual void hit (float damage, WorldEntity* entity);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float dt);
    virtual void draw () const;

  private:
    static FastFactory*               fastFactory;

    static SpriteParticles*           explosionParticles;

    ParticleEmitter*                  emitter;

    float                             angle;
    float                             rotationSpeed;

    Billboard*                        halo;

    WorldEntity* hitEntity; // FIXME TEMPORARY
};

#endif /* _HBOLT_H */
