/*!
 * @file acid_splash.h
 * @brief acid splash projectile
*/

#ifndef _ACIDSPLASH_H
#define _ACIDSPLASH_H

#include "projectile.h"

class Vector;
class Weapon;
class FastFactory;
class Wobblegrid;

class AcidSplash : public Projectile
{
  ObjectListDeclaration(AcidSplash);
  public:
    AcidSplash ();
    virtual ~AcidSplash ();


    virtual void activate();
    virtual void deactivate();

 //   virtual void collidesWith(WorldEntity* entity, const Vector& location);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float dt);
    virtual void draw () const;

  private:
    static FastFactory*               fastFactory;
    Wobblegrid*                       grid;

    float                             angle;
    static const float                rotationSpeed = 1080;


    WorldEntity* hitEntity; // FIXME TEMPORARY
};

#endif /* _ACIDSPLASH_H */
