/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: Benjamin Knecht
*/

#include "player.h"
#include "playable.h"
#include "space_ships/space_ship.h"

#include "event_handler.h"

#include "state.h"
#include "util/hud.h"

#include "debug.h"

ObjectListDefinition(Player);
/**
 * creates a new Player
*/
Player::Player()
{
  //  this->setRelDir(Quaternion(M_PI, Vector(1,0,0)));
  this->registerObject(this, Player::_objectList);

  PRINTF(4)("PLAYER INIT\n");

  this->playable = NULL;
  this->_hud.setVisibility(true);

  this->subscribeEvent(ES_GAME, KeyMapper::PEV_CHANGE_SHIP);
}


/**
 *  destructs the player, deletes alocated memory
 */
Player::~Player ()
{
  this->setPlayable(NULL);
}


bool Player::setPlayable(Playable* playable)
{
  if (this->playable == playable)
    return false;

  // get out of the current Playable
  if (this->playable != NULL)
  {
    PRINTF(4)("Player gets ejected from Playable\n");
    this->_hud.setEnergyWidget(NULL);
    this->_hud.setWeaponManager(NULL);

    Playable* ejectedPlayable = this->playable;

    this->playable = NULL;
    ejectedPlayable->setPlayer(NULL);
  }

  if (playable != NULL)
  {
    PRINTF(4)("Enter new Playable\n");
    this->playable = playable;
    this->_hud.setArmorWidget(this->playable->getHealthWidget());
    if (dynamic_cast<SpaceShip*>(this->playable) != 0)
      this->_hud.setWeaponManager(&this->playable->getWeaponManager(), &dynamic_cast<SpaceShip*>(this->playable)->getWeaponManagerSecondary());
    else
      this->_hud.setWeaponManager(&this->playable->getWeaponManager());

    this->playable->setPlayer(this);
    return true;
  }

  if ( playable == NULL )
    this->playable = NULL;

  return true;
}

bool Player::eject()
{
  return this->setPlayable(NULL);
}


void Player::weaponConfigChanged()
{
  //this->_hud.updateWeaponManager();

  if (dynamic_cast<SpaceShip*>(this->playable) != 0)
      this->_hud.setWeaponManager(&this->playable->getWeaponManager(), &dynamic_cast<SpaceShip*>(this->playable)->getWeaponManagerSecondary());
    else
      this->_hud.setWeaponManager(&this->playable->getWeaponManager());
}


void Player::enterNewPlayable()
{
  /// FIXME this should be in the ObjectManager
  for (ObjectList<Playable>::const_iterator node = Playable::objectList().begin();
       node != Playable::objectList().end();
       ++node)
  {
    if (this->playable != (*node) &&
        ((*node)->getAbsCoor() - this->playable->getAbsCoor()).len() < ((*node)->getEnterRadius()))
    {

      this->setPlayable(*(node));

      break;
    }
  }
}


void Player::process(const Event &event)
{
  if (event.type == KeyMapper::PEV_CHANGE_SHIP && event.bPressed)
  {
    this->enterNewPlayable();
  }

  if (likely(this->playable != NULL))
    this->playable->process(event);
}


