/*!
 * @file glgui_energywidget.h
 * @brief Definition of an EnergyWidget, that displays a bar and a Text
*/

#ifndef _GLGUI_ENERGY_WIDGET_H
#define _GLGUI_ENERGY_WIDGET_H

#include "glgui_box.h"
#include "glgui_bar.h"
#include "glgui_text.h"

namespace OrxGui
{

  //! A class for ...
  class GLGuiEnergyWidget : public GLGuiBox
  {

  public:
    GLGuiEnergyWidget();
    virtual ~GLGuiEnergyWidget();

    void setDisplayedName(const std::string& name);
    void setMaximum(float max);
    void setValue(float value);

    inline GLGuiWidget* getNameWidget() {return &this->_name;};
    inline GLGuiWidget* getValueWidget() {return &this->_valueText;};
    inline GLGuiWidget* getBarWidget() {return &this->_bar;};

  protected:
    virtual void resize();
    virtual void showing();
    virtual void hiding();

  private:
    GLGuiText               _name;
    GLGuiText               _valueText;
    GLGuiBar                _bar;

  };
}
#endif /* _GLGUI_ENERGY_WIDGET_H */
