/*!
 * @file wobblegrid.h
 */

#ifndef _WOBBLEGRID_H
#define _WOBBLEGRID_H

#include "world_entity.h"

class Material;
class TiXmlElement;
class Grid;

class Wobblegrid : public WorldEntity
{
  ObjectListDeclaration(Wobblegrid);
  public:
    Wobblegrid(int size, const TiXmlElement* root = NULL);
    Wobblegrid( const TiXmlElement* root = NULL);
    virtual ~Wobblegrid();

    void init();
    void loadParams(const TiXmlElement* root);

    void setTexture(const std::string& textureFile);

    inline float sgn(float x) { if(likely(x==0)) return 0.0f; else return x / fabsf(x);};
    virtual void tick(float dt);
    virtual void draw() const;

    inline void setUpdateFunction(float (*updateFct)(float value)) { if( updateFct)  this->updateWobble = updateFct;};

  private:
    float (*updateWobble)(float value);

    void orient();

    Material*        material;
    Grid*            grid;	//!< current projected positions transformed into billboard state

    int subdivision;

    int size;

    float angle;
    float angularSpeed;
};

#endif /* _WOBBLEGRID_H */
