/*!
 * @file trail.h
 */

#ifndef _TRAIL_H_
#define _TRAIL_H_

#include "world_entity.h"

class Material;



class Trail : public WorldEntity
{
  ObjectListDeclaration(Trail);
  public:
    Trail(float maxLength, int sections, float radius, PNode* parent);
    Trail(const TiXmlElement* root = NULL);
    virtual ~Trail();

    virtual void loadParams(const TiXmlElement* root);

    void setTexture(const std::string& textureFile);

    virtual void tick(float dt);
    virtual void draw() const;

    /**
     *  length of the trail.
     */
    inline void setLength(float length) { this->length = length;};
    inline float getLength() { return this->length;};

    /**
     *  Amount of sections (parts) of the trail. The more, the rounder it will look
     */
    inline void setSections(int sections) { this->sections = sections;};
    inline int getSections() { return this->sections;};

    /**
     *  Radius of the trail object
     */
    inline void setRadius(float radius) { this->radius = radius;};
    inline float getRadius() { return this->radius;};

  private:
    void init();
    inline Vector catmull(Vector P0, Vector P1, Vector P2, Vector P3, float t) const {return (P1*2 + (P2 - P0)*t + (P0*2 - P1*5- P2*4 - P3)*t*t + (P1*3 -P0 - P2*3 + P3)*t*t*t); };


    Material*              material;

    float maxLength;
    float length;
    float radius;
    int   sections;

    Vector*  nodeList;
};

#endif /* _TRAIL_H_ */
