/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_bar.h"

#include "debug.h"

namespace OrxGui
{

  ObjectListDefinition(GLGuiBar);
  /**
   * @brief standard constructor
  */
  GLGuiBar::GLGuiBar ()
  {
    this->init();

  }


  /**
   * @brief standard deconstructor
   */
  GLGuiBar::~GLGuiBar()
  {}

  /**
   * @brief initializes the GUI-element
   */
  void GLGuiBar::init()
  {
    this->registerObject(this, GLGuiBar::_objectList);

    this->setFrontColor(_changedValueColor, true);

    this->setSize2D(50, 10);

    this->_minimum = 0.0f;
    this->_maximum = 1.0f;
    this->setValue(0.5f);
    this->resize();
  }

  void GLGuiBar::setValue(float value)
  {
    if (value > _maximum)
    {
      value = _maximum;
      PRINTF(2)("Oversteped range, set Value to %f\n", _maximum);
    }
    if (value < _minimum)
    {
      value = _minimum;
      PRINTF(2)("Oversteped range, set Value to %f\n", _minimum);
    }

    this->_value = value;
    this->_frontRect.setSize((this->getSizeX2D() - borderLeft() - borderRight()) * (_value - _minimum) / (_maximum -_minimum)
        ,this->getSizeY2D() - borderTop() - borderBottom());
  }
  void GLGuiBar::setMinimum(float minimum)
  {
    this->_minimum = minimum;
  }
  void GLGuiBar::setMaximum(float maximum)
  {
    this->_maximum = maximum;
  }
  void GLGuiBar::setRange(float minimum, float maximum)
  {
    this->setMinimum(minimum);
    this->setMaximum(maximum);
  }

  void GLGuiBar::setChangedValueColor(const Color& color)
  {
    this->_changedValueColor = color;
  }


  void GLGuiBar::resize()
  {
    GLGuiWidget::resize();

    this->_frontRect.setTopLeft(borderLeft(), borderTop());
    this->_frontRect.setSize((this->getSizeX2D() - borderLeft() - borderRight()) * (_value - _minimum) / (_maximum -_minimum)
        ,this->getSizeY2D() - borderTop() - borderBottom());

  }


  /**
   * @brief draws the GLGuiBar
   */
  void GLGuiBar::draw() const
  {
    this->beginDraw();
    GLGuiWidget::draw();

    this->foreground().select();
    this->drawRect(this->_frontRect);

    this->endDraw();
  }
}
