/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer:
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "executor/executor.h"
#include "util/loading/factory.h"
#include "util/loading/load_param.h"


#include "test_entity.h"
#include "debug.h"
#include "state.h"
#include "shell_command.h"
#include "game_world_data.h"

#include "class_id_DEPRECATED.h"
ObjectListDefinition(TestEntity);
CREATE_FACTORY(TestEntity);



/**
 *
 */
TestEntity::TestEntity ()
{
  this->init();
}


SHELL_COMMAND(test, TestEntity,test);
SHELL_COMMAND(t2, TestEntity,t2);
SHELL_COMMAND(t3, TestEntity,t3);
SHELL_COMMAND(t4, TestEntity, t4);
SHELL_COMMAND(t5, TestEntity,t5);

/**
 *
 */
TestEntity::TestEntity(const TiXmlElement* root)
{
  this->init();

  if( root != NULL)
    this->loadParams(root);
}


/**
 *
 */
TestEntity::~TestEntity ()
{}


/**
 *
 */
void TestEntity::init()
{
  this->registerObject(this, TestEntity::_objectList);
  this->toList(OM_GROUP_00);

}

void TestEntity::test()
{
  CM= State::getCameraman();
  CM->changeCurrTarget( "WorldEntity", "Ebene");
}

void TestEntity::t2()
{
  CM= State::getCameraman();
  CM->createCam();
  CM->setCam(1);
  CM->moveCurrCam(100, 0, 200);
}

void TestEntity::t3()
{
  CM= State::getCameraman();
  CM->moveCurrCam(-300, 0, 0);
}

void TestEntity::t4()
{
  CM= State::getCameraman();

CM->togglFade();
}

void TestEntity::t5()
{
  CM= State::getCameraman();

  CM->setCam(0);
}



/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void TestEntity::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);
}

void TestEntity::draw() const
{


  glColor4f(0,0,0,0);
  glBegin(GL_QUADS);
  glVertex3f(50.,-100.0f,-100.0f);
  glVertex3f(50., -100.0f,100.0f);
  glVertex3f(50., 100.0f,100.0f);
  glVertex3f(50., 100.0f,-100.0f);

  glEnd();

}

/**
 *
 */
void TestEntity::tick (float time)
{

}


void  TestEntity::changeState (bool sta)
{

}
