/*!
 * @file lightning_bolt.h
 * @brief a SoundEntity Projectile
 *  Der Effekt soll folgenderma�n funktionieren:
 * -> Ein Partikel mit einer Blitz-Textur soll sehr schnell erscheinen,
 * -> w�rend er an Intensit� zunimmt soll die Beleuchtung der gerenderten Szene entsprechend zunehmen.
 * -> Je mehr Blitze zum gleichen Zeitpunkt sichtbar sind, desto heller soll die Beleuchtung werden, das hei� die Helligkeitszunahme pro Blitz soll Additiv sein.
 * -> Ein Partikel soll ebenfalls sehr schnell wieder verblassen, dabei soll die Beleuchtung entsprechend der vorhergehenden Zunahme wieder abnehmen (Additiv)
 */

#ifndef _SOUND_ENTITY_H
#define _SOUND_ENTITY_H

#include "world_entity.h"

#include "sound_buffer.h"
#include "sound_source.h"

class Material;

class SoundEntity : public WorldEntity
{
  ObjectListDeclaration(SoundEntity);
  public:
    SoundEntity(const TiXmlElement* root = NULL);
    virtual ~SoundEntity ();

    virtual void loadParams(const TiXmlElement* root);

    void setSoundFile(const std::string fileName);

    virtual void activate();
    virtual void deactivate();

    virtual void tick(float time);

  private:

    OrxSound::SoundSource    soundSource;
    OrxSound::SoundBuffer    soundBuffer;
};

#endif /* _SOUND_ENTITY_H */
