/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON


#include "sound_entity.h"

#include "util/loading/factory.h"
#include "material.h"

#include "sound/resource_sound_buffer.h"





ObjectListDefinition(SoundEntity);
CREATE_FACTORY(SoundEntity);

/**
 *  standard constructor
*/
SoundEntity::SoundEntity (const TiXmlElement* root)
{
  this->registerObject(this, SoundEntity::_objectList);

  this->toList(OM_COMMON);

  this->soundSource.setSourceNode(this);

  if( root != NULL)
    this->loadParams(root);

  this->thunderBuffer = OrxSound::ResourceSoundBuffer("sounds/atmosphere/thunder.wav");
}


/**
 *  standard deconstructor
*/
SoundEntity::~SoundEntity ()
{
}


/**
 * loading stuff
 * @param root xml element
 */
void SoundEntity::loadParams(const TiXmlElement* root)
{
  LoadParam(root, "soundfile", this, SoundEntity, setSoundFile)
      .describe("Sets the file of the sound source");

  LoadParam(root, "frequency", this, SoundEntity, setSoundFile)
      .describe("Sets the file of the sound source");
}


/**
 * sets the sound file
 * @param fileName name of the sound source
 */
void SoundEntity::setSoundFile(const std::string fileName)
{
  this->soundBuffer = OrxSound::ResourceSoundBuffer(fileName);
}


void SoundEntity::activate()
{
}


void SoundEntity::deactivate()
{

}


/**
 *  signal tick, time dependent things will be handled here
 * @param time since last tick
*/
void SoundEntity::tick (float dt)
{

}



