

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:


   @todo: direction in which the projectile flights
   @todo: a target to set/hit
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "world_entities/projectiles/projectile.h"

#include "world_entity.h"
#include "static_model.h"
#include "weapon_manager.h"
#include "util/loading/factory.h"


#include "loading/fast_factory.h"

#include "fps_sniper_rifle.h"


#include "effects/explosion.h"





ObjectListDefinition(FPSSniperRifle);
CREATE_FACTORY(FPSSniperRifle);

/**
 *  standard constructor

   creates a new weapon
*/
FPSSniperRifle::FPSSniperRifle ( int leftRight)
  : Weapon()
{
  this->init();

  this->leftRight = leftRight;
}


FPSSniperRifle::FPSSniperRifle(const TiXmlElement* root)
{
  this->init();

  if (root != NULL)
    this->loadParams(root);
}

/**
 *  standard deconstructor
*/
FPSSniperRifle::~FPSSniperRifle ()
{
  // model will be deleted from WorldEntity-destructor
  if( this->material != NULL)
    delete this->material;
}


void FPSSniperRifle::init()
{
  this->registerObject(this, FPSSniperRifle::_objectList);

  this->loadModel("models/guns/fps_sniper_rifle.obj", 0.2);
  this->material = new Material();
  this->material->setIllum(3);
  this->material->setAmbient(1.0, 1.0, 1.0);
  this->material->setDiffuseMap("textures/rifle01tex.jpg");

  this->setStateDuration(WS_SHOOTING, .1);
  this->setStateDuration(WS_RELOADING, .1);
  this->setStateDuration(WS_ACTIVATING, .4);
  this->setStateDuration(WS_DEACTIVATING, .4);

  this->setEnergyMax(100000);
  this->increaseEnergy(100000);
  //this->minCharge = 2;

  this->setActionSound(WA_SHOOT, "sounds/laser.wav");
  this->setActionSound(WA_ACTIVATE, "sounds/voices/lasers.wav");


  this->setCapability(WTYPE_ALLDIRS | WTYPE_DIRECTIONAL);
  this->setProjectileTypeC("Laser");
  this->prepareProjectiles(20);

}


void FPSSniperRifle::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);

}


/**
 *  this activates the weapon

   This is needed, since there can be more than one weapon on a ship. the
   activation can be connected with an animation. for example the weapon is
   been armed out.
*/
void FPSSniperRifle::activate()
{
}


/**
 *  this deactivates the weapon

   This is needed, since there can be more than one weapon on a ship. the
   activation can be connected with an animation. for example the weapon is
   been armed out.
*/
void FPSSniperRifle::deactivate()
{
}


/**
 *  fires the weapon

   this is called from the player.cc, when fire-button is been pushed
   @todo: the ObjectManager deliveres Projectiles not TestBullets! this should be diffrent
*/
void FPSSniperRifle::fire()
{
  Projectile* pj =  this->getProjectile();
  if (pj == NULL)
    return;

//   Explosion::explode(this, Vector(0.1,0.1,0.1));

  pj->setParent(this);
  pj->setParentMode(PNODE_ROTATE_AND_MOVE);

  pj->setVelocity(this->getAbsDir().apply(Vector(1,0,0))*550 + VECTOR_RAND(5) );

  pj->setAbsCoor(this->getEmissionPoint() + this->getAbsDirX() * 25.0f);
  pj->setAbsDir(this->getAbsDir());
  pj->activate();
}




/**
 *  this will draw the weapon
 */
void FPSSniperRifle::draw () const
{
  /* draw gun body */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);

  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

  if( this->leftRight == W_RIGHT)
    glScalef(1.0, 1.0, -1.0);

  this->material->select();
  this->getModel()->draw();
  //static_cast<StaticModel*>(this->getModel())->draw();

  glPopMatrix();

}



